/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourceInfoTest {
    private DataSourceInfo dsi;

    @Before
    public void setUp() throws Exception {
        this.dsi = new DataSourceInfo();
        this.dsi.setUserName("a");
        this.dsi.setPassword("b");
        this.dsi.setMinConnections(1);
        this.dsi.setMaxConnections(2);
        this.dsi.setJdbcDriver("b");
        this.dsi.setDataSourceUrl("c");
        this.dsi.setAdapterClassName("d");
    }

    @Test
    public void testDefaultValues() throws Exception {
        DataSourceInfo localDsi = new DataSourceInfo();
        Assert.assertEquals((long)1L, (long)localDsi.getMinConnections());
        Assert.assertTrue((localDsi.getMinConnections() <= localDsi.getMaxConnections() ? 1 : 0) != 0);
    }

    @Test
    public void testClone() throws Exception {
        DataSourceInfo dsiClone = this.dsi.cloneInfo();
        Assert.assertEquals((Object)this.dsi, (Object)dsiClone);
        Assert.assertTrue((this.dsi != dsiClone ? 1 : 0) != 0);
    }

    @Test
    public void testSerialize() throws Exception {
        DataSourceInfo dsiUnserialized = Util.cloneViaSerialization(this.dsi);
        Assert.assertEquals((Object)this.dsi, (Object)dsiUnserialized);
        Assert.assertTrue((this.dsi != dsiUnserialized ? 1 : 0) != 0);
    }
}

