/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.NoopDataChannelMetaData;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.xml.XMLDataMapLoader;
import org.apache.cayenne.configuration.xml.XMLReaderProvider;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.URLResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.XMLReader;

public class XMLDataChannelDescriptorLoaderTest {
    private Injector injector;

    @Before
    public void setUp() {
        Module testModule = binder -> {
            binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
            binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
            binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
            binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
            binder.bind(HandlerFactory.class).to(DefaultHandlerFactory.class);
            binder.bind(DataChannelMetaData.class).to(NoopDataChannelMetaData.class);
            binder.bind(XMLReader.class).toProviderInstance((Provider)new XMLReaderProvider(false)).withoutScope();
        };
        this.injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
    }

    @Test
    public void testLoadEmpty() {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        String testConfigName = "testConfig1";
        URL url = this.getClass().getResource("cayenne-" + testConfigName + ".xml");
        ConfigurationTree<DataChannelDescriptor> tree = loader.load(new URLResource(url));
        Assert.assertNotNull(tree);
        Assert.assertNotNull((Object)tree.getRootNode());
        Assert.assertEquals((Object)testConfigName, (Object)tree.getRootNode().getName());
    }

    @Test
    public void testLoad_MissingConfig() throws Exception {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        try {
            loader.load(new URLResource(new URL("file:///no_such_resource")));
            Assert.fail((String)"No exception was thrown on bad absent config name");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Test(expected=CayenneRuntimeException.class)
    public void loadInvalidVersion() throws Exception {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        URL url = this.getClass().getResource("cayenne-testConfig4.xml");
        loader.load(new URLResource(url));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void loadInvalidNamespace() throws Exception {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        URL url = this.getClass().getResource("cayenne-testConfig5.xml");
        loader.load(new URLResource(url));
    }

    @Test
    public void testLoadDataMap() {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        String testConfigName = "testConfig2";
        URL url = this.getClass().getResource("cayenne-" + testConfigName + ".xml");
        ConfigurationTree<DataChannelDescriptor> tree = loader.load(new URLResource(url));
        Assert.assertNotNull(tree);
        Assert.assertNotNull((Object)tree.getRootNode());
        Assert.assertEquals((Object)testConfigName, (Object)tree.getRootNode().getName());
        Collection<DataMap> maps = tree.getRootNode().getDataMaps();
        Assert.assertEquals((long)1L, (long)maps.size());
        Assert.assertEquals((Object)"testConfigMap2", (Object)maps.iterator().next().getName());
    }

    @Test
    public void testLoadDataEverything() {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        String testConfigName = "testConfig3";
        URL url = this.getClass().getResource("cayenne-" + testConfigName + ".xml");
        ConfigurationTree<DataChannelDescriptor> tree = loader.load(new URLResource(url));
        Assert.assertNotNull(tree);
        DataChannelDescriptor descriptor = tree.getRootNode();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)testConfigName, (Object)descriptor.getName());
        Collection<DataMap> maps = descriptor.getDataMaps();
        Assert.assertEquals((long)2L, (long)maps.size());
        Iterator<DataMap> mapsIt = maps.iterator();
        DataMap map1 = mapsIt.next();
        DataMap map2 = mapsIt.next();
        Assert.assertEquals((Object)"testConfigMap3_1", (Object)map1.getName());
        Assert.assertEquals((Object)"testConfigMap3_2", (Object)map2.getName());
        Collection<DataNodeDescriptor> nodes = descriptor.getNodeDescriptors();
        Assert.assertEquals((long)1L, (long)nodes.size());
        DataNodeDescriptor node1 = nodes.iterator().next();
        Assert.assertEquals((Object)"testConfigNode3", (Object)node1.getName());
        Assert.assertNull((Object)node1.getParameters());
        Assert.assertNotNull((Object)node1.getDataSourceDescriptor());
        Assert.assertEquals((long)1L, (long)node1.getDataSourceDescriptor().getMinConnections());
        Assert.assertEquals((long)1L, (long)node1.getDataSourceDescriptor().getMaxConnections());
        Assert.assertEquals((Object)"org.example.test.Adapter", (Object)node1.getAdapterType());
        Assert.assertEquals((Object)"org.example.test.DataSourceFactory", (Object)node1.getDataSourceFactoryType());
        Assert.assertEquals((Object)"org.example.test.SchemaUpdateStartegy", (Object)node1.getSchemaUpdateStrategyType());
        Assert.assertNotNull(node1.getDataMapNames());
        Assert.assertEquals((long)1L, (long)node1.getDataMapNames().size());
        Assert.assertEquals((Object)"testConfigMap3_2", (Object)node1.getDataMapNames().iterator().next());
    }
}

