/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.BaseHandlerTest;
import org.apache.cayenne.configuration.xml.DbKeyGeneratorHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class DbKeyGeneratorHandlerTest
extends BaseHandlerTest {
    @Test
    public void testParsing() throws Exception {
        final DbEntity dbEntity = new DbEntity("TEST");
        this.parse("db-key-generator", new BaseHandlerTest.HandlerFactory(){

            @Override
            public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler parent) {
                return new DbKeyGeneratorHandler(parent, dbEntity);
            }
        });
        Assert.assertNotNull((Object)dbEntity.getPrimaryKeyGenerator());
        Assert.assertEquals((Object)"gallery_seq", (Object)dbEntity.getPrimaryKeyGenerator().getGeneratorName());
        Assert.assertEquals((long)20L, (long)dbEntity.getPrimaryKeyGenerator().getKeyCacheSize().intValue());
        Assert.assertEquals((Object)"ORACLE", (Object)dbEntity.getPrimaryKeyGenerator().getGeneratorType());
    }
}

