/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockServletConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import org.apache.cayenne.configuration.web.MockModule1;
import org.apache.cayenne.configuration.web.MockModule2;
import org.apache.cayenne.configuration.web.WebConfiguration;
import org.apache.cayenne.di.Module;
import org.junit.Assert;
import org.junit.Test;

public class WebConfigurationTest {
    @Test
    public void testFilterCreateModules_Standard() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        WebConfiguration configuration = new WebConfiguration((FilterConfig)config);
        Module m1 = binder -> {};
        Module m2 = binder -> {};
        Collection<Module> modules = configuration.createModules(m1, m2);
        Assert.assertEquals((long)2L, (long)modules.size());
        Iterator<Module> it = modules.iterator();
        Assert.assertSame((Object)m1, (Object)it.next());
        Assert.assertSame((Object)m2, (Object)it.next());
    }

    @Test
    public void testFilterCreateModules_Extra() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        String exra = String.format("%s, \n%s", MockModule1.class.getName(), MockModule2.class.getName());
        config.setInitParameter("extra-modules", exra);
        WebConfiguration configuration = new WebConfiguration((FilterConfig)config);
        Module m1 = binder -> {};
        Module m2 = binder -> {};
        Collection<Module> modules = configuration.createModules(m1, m2);
        Assert.assertEquals((long)4L, (long)modules.size());
        Iterator<Module> it = modules.iterator();
        Assert.assertSame((Object)m1, (Object)it.next());
        Assert.assertSame((Object)m2, (Object)it.next());
        Assert.assertTrue((boolean)(it.next() instanceof MockModule1));
        Assert.assertTrue((boolean)(it.next() instanceof MockModule2));
    }

    @Test
    public void testServletCreateModules_Extra() throws Exception {
        MockServletConfig config = new MockServletConfig();
        String exra = String.format("%s, \n%s", MockModule1.class.getName(), MockModule2.class.getName());
        config.setInitParameter("extra-modules", exra);
        WebConfiguration configuration = new WebConfiguration((ServletConfig)config);
        Module m1 = binder -> {};
        Module m2 = binder -> {};
        Collection<Module> modules = configuration.createModules(m1, m2);
        Assert.assertEquals((long)4L, (long)modules.size());
        Iterator<Module> it = modules.iterator();
        Assert.assertSame((Object)m1, (Object)it.next());
        Assert.assertSame((Object)m2, (Object)it.next());
        Assert.assertTrue((boolean)(it.next() instanceof MockModule1));
        Assert.assertTrue((boolean)(it.next() instanceof MockModule2));
    }

    @Test
    public void testFilterConfigurationLocation_Name() {
        MockFilterConfig config1 = new MockFilterConfig();
        config1.setFilterName("cayenne-x");
        WebConfiguration configuration1 = new WebConfiguration((FilterConfig)config1);
        Assert.assertEquals((Object)"cayenne-x.xml", (Object)configuration1.getConfigurationLocation());
        MockFilterConfig config2 = new MockFilterConfig();
        config2.setFilterName("cayenne-y.xml");
        WebConfiguration configuration2 = new WebConfiguration((FilterConfig)config2);
        Assert.assertEquals((Object)"cayenne-y.xml", (Object)configuration2.getConfigurationLocation());
        MockFilterConfig config3 = new MockFilterConfig();
        config3.setFilterName("a/b/c/cayenne-z.xml");
        WebConfiguration configuration3 = new WebConfiguration((FilterConfig)config3);
        Assert.assertEquals((Object)"a/b/c/cayenne-z.xml", (Object)configuration3.getConfigurationLocation());
    }

    @Test
    public void testServletConfigurationLocation_Name() {
        MockServletConfig config1 = new MockServletConfig();
        config1.setServletName("cayenne-x");
        WebConfiguration configuration1 = new WebConfiguration((ServletConfig)config1);
        Assert.assertEquals((Object)"cayenne-x.xml", (Object)configuration1.getConfigurationLocation());
        MockServletConfig config2 = new MockServletConfig();
        config2.setServletName("cayenne-y.xml");
        WebConfiguration configuration2 = new WebConfiguration((ServletConfig)config2);
        Assert.assertEquals((Object)"cayenne-y.xml", (Object)configuration2.getConfigurationLocation());
        MockServletConfig config3 = new MockServletConfig();
        config3.setServletName("a/b/c/cayenne-z.xml");
        WebConfiguration configuration3 = new WebConfiguration((ServletConfig)config3);
        Assert.assertEquals((Object)"a/b/c/cayenne-z.xml", (Object)configuration3.getConfigurationLocation());
    }

    @Test
    public void testFilterConfigurationLocation_Parameter() {
        MockFilterConfig config1 = new MockFilterConfig();
        config1.setFilterName("cayenne-x");
        config1.setInitParameter("configuration-location", "cayenne-y.xml");
        WebConfiguration configuration1 = new WebConfiguration((FilterConfig)config1);
        Assert.assertEquals((Object)"cayenne-y.xml", (Object)configuration1.getConfigurationLocation());
    }

    @Test
    public void testServletConfigurationLocation_Parameter() {
        MockServletConfig config1 = new MockServletConfig();
        config1.setServletName("cayenne-x");
        config1.setInitParameter("configuration-location", "cayenne-y.xml");
        WebConfiguration configuration1 = new WebConfiguration((ServletConfig)config1);
        Assert.assertEquals((Object)"cayenne-y.xml", (Object)configuration1.getConfigurationLocation());
    }

    @Test
    public void testFilterParameters() {
        MockFilterConfig config1 = new MockFilterConfig();
        config1.setFilterName("cayenne-x");
        config1.setInitParameter("configuration-location", "cayenne-y.xml");
        config1.setInitParameter("test", "xxx");
        WebConfiguration configuration1 = new WebConfiguration((FilterConfig)config1);
        Map<String, String> parameters = configuration1.getParameters();
        Assert.assertNotSame(parameters, configuration1.getParameters());
        Assert.assertEquals(parameters, configuration1.getParameters());
        Assert.assertEquals((long)2L, (long)parameters.size());
        Assert.assertEquals((Object)"cayenne-y.xml", (Object)parameters.get("configuration-location"));
        Assert.assertEquals((Object)"xxx", (Object)parameters.get("test"));
    }

    @Test
    public void testFilterOtherParameters() {
        MockFilterConfig config1 = new MockFilterConfig();
        config1.setFilterName("cayenne-x");
        config1.setInitParameter("configuration-location", "cayenne-y.xml");
        config1.setInitParameter("extra-modules", "M1,M2");
        config1.setInitParameter("test", "xxx");
        WebConfiguration configuration1 = new WebConfiguration((FilterConfig)config1);
        Map<String, String> parameters = configuration1.getOtherParameters();
        Assert.assertNotSame(parameters, configuration1.getOtherParameters());
        Assert.assertEquals(parameters, configuration1.getOtherParameters());
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((Object)"xxx", (Object)parameters.get("test"));
    }
}

