/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.MockDataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.web.SessionContextRequestHandler;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ServletContextHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestStart_bindContext() {
        Module module = binder -> {
            binder.bind(DataChannel.class).to(MockDataChannel.class);
            binder.bind(ObjectContextFactory.class).toInstance((Object)new ObjectContextFactory(){

                @Override
                public ObjectContext createContext(DataChannel parent) {
                    return (ObjectContext)Mockito.mock(ObjectContext.class);
                }

                @Override
                public ObjectContext createContext() {
                    return (ObjectContext)Mockito.mock(ObjectContext.class);
                }
            });
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{module});
        SessionContextRequestHandler handler = new SessionContextRequestHandler();
        injector.injectMembers((Object)handler);
        MockHttpSession session = new MockHttpSession();
        BaseContext.bindThreadObjectContext(null);
        try {
            MockHttpServletRequest request1 = new MockHttpServletRequest();
            MockHttpServletResponse response1 = new MockHttpServletResponse();
            request1.setSession((HttpSession)session);
            handler.requestStart((ServletRequest)request1, (ServletResponse)response1);
            ObjectContext c1 = BaseContext.getThreadObjectContext();
            Assert.assertNotNull((Object)c1);
            handler.requestEnd((ServletRequest)request1, (ServletResponse)response1);
            try {
                BaseContext.getThreadObjectContext();
                Assert.fail((String)"thread context not null");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            MockHttpServletRequest request2 = new MockHttpServletRequest();
            MockHttpServletResponse response2 = new MockHttpServletResponse();
            request2.setSession((HttpSession)session);
            handler.requestStart((ServletRequest)request2, (ServletResponse)response2);
            ObjectContext c2 = BaseContext.getThreadObjectContext();
            Assert.assertSame((Object)c1, (Object)c2);
            handler.requestEnd((ServletRequest)request2, (ServletResponse)response2);
            try {
                BaseContext.getThreadObjectContext();
                Assert.fail((String)"thread context not null");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            MockHttpServletRequest request3 = new MockHttpServletRequest();
            MockHttpServletResponse response3 = new MockHttpServletResponse();
            request3.setSession((HttpSession)new MockHttpSession());
            handler.requestStart((ServletRequest)request3, (ServletResponse)response3);
            ObjectContext c3 = BaseContext.getThreadObjectContext();
            Assert.assertNotNull((Object)c3);
            Assert.assertNotSame((Object)c1, (Object)c3);
            handler.requestEnd((ServletRequest)request3, (ServletResponse)response3);
            try {
                BaseContext.getThreadObjectContext();
                Assert.fail((String)"thread context not null");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            BaseContext.bindThreadObjectContext(null);
        }
    }
}

