/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionalOperation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ServerRuntimeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerformInTransaction() {
        final BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        Mockito.when((Object)txFactory.createTransaction()).thenReturn((Object)tx);
        Module module = binder -> binder.bind(TransactionFactory.class).toInstance((Object)txFactory);
        ServerRuntime runtime = ServerRuntime.builder().addConfig("xxxx").addModule(module).build();
        try {
            final Object expectedResult = new Object();
            Object result = runtime.performInTransaction(new TransactionalOperation<Object>(){

                @Override
                public Object perform() {
                    Assert.assertSame((Object)tx, (Object)BaseTransaction.getThreadTransaction());
                    return expectedResult;
                }
            });
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            runtime.shutdown();
        }
    }

    @Deprecated
    @Test
    public void testDefaultConstructor_SingleLocation() {
        ServerRuntime runtime = new ServerRuntime("xxxx", new Module[0]);
        List locations = (List)runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("xxxx"), (Object)locations);
        Collection<Module> modules = runtime.getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Module m0 = modules.iterator().next();
        Assert.assertTrue((boolean)(m0 instanceof ServerModule));
    }

    @Test
    @Deprecated
    public void testDefaultConstructor_MultipleLocations() {
        ServerRuntime runtime = new ServerRuntime(new String[]{"xxxx", "yyyy"}, new Module[0]);
        List locations = (List)runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("xxxx", "yyyy"), (Object)locations);
        Collection<Module> modules = runtime.getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Module m0 = modules.iterator().next();
        Assert.assertTrue((boolean)(m0 instanceof ServerModule));
    }

    @Test
    @Deprecated
    public void testConstructor_Modules() {
        boolean[] configured = new boolean[2];
        Module m1 = binder -> {
            configured[0] = true;
        };
        Module m2 = binder -> {
            configured[1] = true;
        };
        ServerRuntime runtime = new ServerRuntime(Arrays.asList(m1, m2));
        Collection<Module> modules = runtime.getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Assert.assertTrue((boolean)configured[0]);
        Assert.assertTrue((boolean)configured[1]);
    }

    @Test
    @Deprecated
    public void testGetDataChannel_CustomModule() {
        DataChannel channel = new DataChannel(){

            @Override
            public EntityResolver getEntityResolver() {
                return null;
            }

            @Override
            public EventManager getEventManager() {
                return null;
            }

            @Override
            public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
                return null;
            }

            @Override
            public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
                return null;
            }
        };
        Module module = binder -> binder.bind(DataChannel.class).toInstance((Object)channel);
        ServerRuntime runtime = new ServerRuntime("Yuis", module);
        Assert.assertSame((Object)channel, (Object)runtime.getChannel());
    }

    @Test
    @Deprecated
    public void testGetObjectContext_CustomModule() {
        final DataContext context = new DataContext();
        ObjectContextFactory factory = new ObjectContextFactory(){

            @Override
            public ObjectContext createContext(DataChannel parent) {
                return context;
            }

            @Override
            public ObjectContext createContext() {
                return context;
            }
        };
        Module module = binder -> binder.bind(ObjectContextFactory.class).toInstance((Object)factory);
        ServerRuntime runtime = new ServerRuntime("mnYw", module);
        Assert.assertSame((Object)context, (Object)runtime.newContext());
        Assert.assertSame((Object)context, (Object)runtime.newContext());
    }
}

