/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collections;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.DefaultDataRowStoreFactory;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.MockEventManager;
import org.apache.cayenne.event.NoopEventBridgeProvider;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.tx.DefaultTransactionFactory;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionManager;
import org.junit.Assert;
import org.junit.Test;

public class DataContextFactoryTest {
    @Test
    public void testCreateDataContextWithDedicatedCache() throws Exception {
        MockEventManager eventManager = new MockEventManager();
        DataDomain domain = new DataDomain("d1");
        domain.setSharedCacheEnabled(false);
        Module testModule = binder -> {
            binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
            binder.bind(DataDomain.class).toInstance((Object)domain);
            binder.bind(EventManager.class).toInstance((Object)eventManager);
            binder.bind(QueryCache.class).toInstance((Object)new MapQueryCache(5));
            binder.bind(RuntimeProperties.class).toInstance((Object)new DefaultRuntimeProperties(Collections.emptyMap()));
            binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
            binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
            binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
            binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
            binder.bind(EventBridge.class).toProvider(NoopEventBridgeProvider.class);
            binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataContextFactory factory = new DataContextFactory();
        injector.injectMembers((Object)factory);
        DataContext c3 = (DataContext)factory.createContext();
        Assert.assertNotNull((Object)c3.getObjectStore().getDataRowCache());
        Assert.assertNull((Object)domain.getSharedSnapshotCache());
        Assert.assertNotSame((Object)c3.getObjectStore().getDataRowCache(), (Object)domain.getSharedSnapshotCache());
    }

    @Test
    public void testCreateDataContextValidation() throws Exception {
        MockEventManager eventManager = new MockEventManager();
        DataDomain domain = new DataDomain("d1");
        domain.setValidatingObjectsOnCommit(true);
        Module testModule = binder -> {
            binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
            binder.bind(DataDomain.class).toInstance((Object)domain);
            binder.bind(EventManager.class).toInstance((Object)eventManager);
            binder.bind(QueryCache.class).toInstance((Object)new MapQueryCache(5));
            binder.bind(RuntimeProperties.class).toInstance((Object)new DefaultRuntimeProperties(Collections.emptyMap()));
            binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
            binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
            binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
            binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            binder.bind(EventBridge.class).toProvider(NoopEventBridgeProvider.class);
            binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        domain.setDataRowStoreFactory((DataRowStoreFactory)injector.getInstance(DataRowStoreFactory.class));
        DataContextFactory factory = new DataContextFactory();
        injector.injectMembers((Object)factory);
        DataContext c1 = (DataContext)factory.createContext();
        Assert.assertTrue((boolean)c1.isValidatingObjectsOnCommit());
        domain.setValidatingObjectsOnCommit(false);
        DataContext c2 = (DataContext)factory.createContext();
        Assert.assertFalse((boolean)c2.isValidatingObjectsOnCommit());
    }
}

