/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.dbsync.CreateIfNoSchemaStrategy;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyBase;
import org.apache.cayenne.access.dbsync.TstSchemaUpdateStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-sus.xml")
public class SchemaUpdateStrategyIT
extends SchemaUpdateStrategyBase {
    @Test
    public void testCreateIfNoSchemaStrategy() throws Exception {
        this.setStrategy(CreateIfNoSchemaStrategy.class);
        String template = "SELECT #result('id' 'int') FROM SUS1";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(query), observer);
        Map<String, Boolean> nameTables = this.tablesMap();
        Assert.assertTrue((boolean)nameTables.get("SUS1"));
        Assert.assertEquals((long)2L, (long)this.existingTables().size());
        this.node.performQueries(Collections.singletonList(query), observer);
        Assert.assertEquals((long)2L, (long)this.existingTables().size());
    }

    @Test
    public void testNoStandardSchema() throws Exception {
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.setStrategy(TstSchemaUpdateStrategy.class);
        this.node.performQueries(Collections.singletonList(query), observer);
        Assert.assertTrue((boolean)(this.node.getSchemaUpdateStrategy() instanceof TstSchemaUpdateStrategy));
    }
}

