/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.DefaultDataRowStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.MockEventBridge;
import org.apache.cayenne.event.MockEventBridgeProvider;
import org.apache.cayenne.event.NoopEventBridgeProvider;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.tx.DefaultTransactionFactory;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-multi-tier.xml")
public class DefaultDataRowStoreFactoryIT
extends ServerCase {
    @Test
    public void testGetDataRowStore() throws Exception {
        ServerRuntime runtime = (ServerRuntime)this.getUnitTestInjector().getInstance(ServerRuntime.class);
        DataRowStore dataStore = ((DataRowStoreFactory)runtime.getInjector().getInstance(DataRowStoreFactory.class)).createDataRowStore("test");
        Assert.assertNotNull((Object)dataStore);
    }

    @Test
    public void testGetDataRowStoreWithParameters() {
        DataDomain DOMAIN = new DataDomain("test");
        DefaultEventManager EVENT_MANAGER = new DefaultEventManager();
        int CACHE_SIZE = 500;
        Module testModule = binder -> {
            binder.bind(DataDomain.class).toInstance((Object)DOMAIN);
            binder.bind(EventManager.class).toInstance((Object)EVENT_MANAGER);
            binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
            binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
            binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
            binder.bind(EventBridge.class).toProvider(NoopEventBridgeProvider.class);
            binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
            ServerModule.setSnapshotCacheSize(binder, 500);
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataRowStore dataStore = ((DataRowStoreFactory)injector.getInstance(DataRowStoreFactory.class)).createDataRowStore("test");
        Assert.assertNotNull((Object)dataStore);
        Assert.assertEquals((long)dataStore.maximumSize(), (long)500L);
    }

    @Test
    public void testGetDataRowStoreWithBridge() {
        DataDomain DOMAIN = new DataDomain("test");
        DefaultEventManager EVENT_MANAGER = new DefaultEventManager();
        Module testModule = binder -> {
            binder.bind(DataDomain.class).toInstance((Object)DOMAIN);
            binder.bind(EventManager.class).toInstance((Object)EVENT_MANAGER);
            binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
            binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
            binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
            binder.bind(EventBridge.class).toProvider(MockEventBridgeProvider.class);
            binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
            ServerModule.contributeProperties(binder);
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataRowStore dataStore = ((DataRowStoreFactory)injector.getInstance(DataRowStoreFactory.class)).createDataRowStore("test");
        Assert.assertEquals(dataStore.getEventBridge().getClass(), MockEventBridge.class);
    }
}

