/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_people.CustomerRepresentative;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataContextEJBQLInheritanceIT
extends PeopleProjectCase {
    @Inject
    protected ObjectContext context;

    @Before
    public void setUp() throws Exception {
        TableHelper person = new TableHelper(this.dbHelper, "PERSON");
        person.setColumns(new String[]{"PERSON_ID", "NAME", "PERSON_TYPE", "SALARY"}).setColumnTypes(new int[]{4, 12, 1, 6});
        person.insert(new Object[]{1, "a", "EE", 20000});
        person.insert(new Object[]{2, "b", "EE", 25000});
        person.insert(new Object[]{4, "c", "EM", 30000});
        person.insert(new Object[]{5, "d", "EM", 40000});
        person.insert(new Object[]{6, "e", "C", null});
    }

    @Test
    public void testSelect() throws Exception {
        EJBQLQuery superclass = new EJBQLQuery("select p from AbstractPerson p ORDER BY p.name");
        List superclassResult = this.context.performQuery(superclass);
        Assert.assertEquals((long)5L, (long)superclassResult.size());
        Assert.assertEquals((Object)Employee.class.getName(), (Object)superclassResult.get(0).getClass().getName());
        Assert.assertEquals((Object)Employee.class.getName(), (Object)superclassResult.get(1).getClass().getName());
        Assert.assertEquals((Object)Manager.class.getName(), (Object)superclassResult.get(2).getClass().getName());
        Assert.assertEquals((Object)Manager.class.getName(), (Object)superclassResult.get(3).getClass().getName());
        Assert.assertEquals((Object)CustomerRepresentative.class.getName(), (Object)superclassResult.get(4).getClass().getName());
        EJBQLQuery subclass = new EJBQLQuery("select e from Employee e ORDER BY e.name");
        List subclassResult = this.context.performQuery(subclass);
        Assert.assertEquals((long)4L, (long)subclassResult.size());
        Assert.assertEquals((Object)Employee.class.getName(), (Object)subclassResult.get(0).getClass().getName());
        Assert.assertEquals((Object)Employee.class.getName(), (Object)subclassResult.get(1).getClass().getName());
        Assert.assertEquals((Object)Manager.class.getName(), (Object)subclassResult.get(2).getClass().getName());
        Assert.assertEquals((Object)Manager.class.getName(), (Object)subclassResult.get(3).getClass().getName());
    }
}

