/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PregeneratedPKIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testLongPk() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("XXX");
        this.updateId(this.context, a.getObjectId());
        Object pk = a.getObjectId().getReplacementIdMap().get("ARTIST_ID");
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((Object)pk, (Object)Cayenne.longPKForObject(a));
        this.context.commitChanges();
        Object pkAfterCommit = a.getObjectId().getIdSnapshot().get("ARTIST_ID");
        Assert.assertEquals((Object)pk, (Object)pkAfterCommit);
    }

    void updateId(DataContext context, ObjectId id) throws Exception {
        DbEntity entity = context.getEntityResolver().getDbEntity("ARTIST");
        DataNode node = context.getParentDataDomain().lookupDataNode(entity.getDataMap());
        Object pk = node.getAdapter().getPkGenerator().generatePk(node, entity.getPrimaryKeys().iterator().next());
        id.getReplacementIdMap().put("ARTIST_ID", pk);
    }
}

