/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.hybrid.HybridEntity1;
import org.apache.cayenne.testdo.hybrid.HybridEntity2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-hybrid-data-object.xml")
public class HybridDataObjectIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testCreateNew() {
        HybridEntity1 entity1 = this.context.newObject(HybridEntity1.class);
        HybridEntity2 entity2 = this.context.newObject(HybridEntity2.class);
        this.context.commitChanges();
        Assert.assertNull((Object)entity1.values);
        Assert.assertNull((Object)entity2.values);
        HybridEntity1 selectEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(this.context);
        Assert.assertEquals((long)0L, (long)selectEntity1.getIntField());
        Assert.assertEquals(null, (Object)selectEntity1.getStrField());
        HybridEntity2 selectEntity2 = (HybridEntity2)ObjectSelect.query(HybridEntity2.class).selectOne(this.context);
        Assert.assertEquals((long)0L, (long)selectEntity2.getIntField());
        Assert.assertEquals(null, (Object)selectEntity2.getStrField());
    }

    @Test
    public void testSetFieldAttributes() {
        HybridEntity1 entity1 = this.context.newObject(HybridEntity1.class);
        entity1.setIntField(123);
        entity1.setStrField("abc");
        HybridEntity2 entity2 = this.context.newObject(HybridEntity2.class);
        entity2.setIntField(321);
        entity2.setStrField("cba");
        entity2.setHybridEntity1(entity1);
        Assert.assertNull((Object)entity1.values);
        Assert.assertNull((Object)entity2.values);
        this.context.commitChanges();
        HybridEntity1 selectEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(this.context);
        Assert.assertEquals((long)123L, (long)selectEntity1.getIntField());
        Assert.assertEquals((Object)"abc", (Object)selectEntity1.getStrField());
        HybridEntity2 selectEntity2 = (HybridEntity2)ObjectSelect.query(HybridEntity2.class).selectOne(this.context);
        Assert.assertEquals((long)321L, (long)selectEntity2.getIntField());
        Assert.assertEquals((Object)"cba", (Object)selectEntity2.getStrField());
        Assert.assertEquals((Object)selectEntity1, (Object)selectEntity2.getHybridEntity1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDynamicDbAttributes() {
        this.addRuntimeAttribute(HybridEntity1.class, "FLOAT_FIELD", "double");
        this.addRuntimeAttribute(HybridEntity2.class, "BOOLEAN_FIELD", "boolean");
        try {
            HybridEntity1 entity1 = this.context.newObject(HybridEntity1.class);
            entity1.writeProperty("FLOAT_FIELD", 3.14);
            HybridEntity2 entity2 = this.context.newObject(HybridEntity2.class);
            entity2.writeProperty("BOOLEAN_FIELD", true);
            Assert.assertNotNull((Object)entity1.values);
            Assert.assertNotNull((Object)entity2.values);
            this.context.commitChanges();
            entity1.writeProperty("FLOAT_FIELD", 2.17);
            entity2.writeProperty("BOOLEAN_FIELD", false);
            HybridEntity1 selectEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(this.context);
            Assert.assertEquals((Object)2.17, (Object)selectEntity1.readProperty("FLOAT_FIELD"));
            HybridEntity2 selectEntity2 = (HybridEntity2)ObjectSelect.query(HybridEntity2.class).selectOne(this.context);
            Assert.assertEquals((Object)false, (Object)selectEntity2.readProperty("BOOLEAN_FIELD"));
            ObjectContext cleanContext = this.runtime.newContext();
            HybridEntity1 selectCleanEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(cleanContext);
            Assert.assertEquals((Object)3.14, (Object)selectCleanEntity1.readProperty("FLOAT_FIELD"));
            HybridEntity2 selectCleanEntity2 = (HybridEntity2)ObjectSelect.query(HybridEntity2.class).selectOne(cleanContext);
            Assert.assertEquals((Object)true, (Object)selectCleanEntity2.readProperty("BOOLEAN_FIELD"));
        }
        finally {
            this.removeRuntimeAttribute(HybridEntity1.class, "FLOAT_FIELD");
            this.removeRuntimeAttribute(HybridEntity2.class, "BOOLEAN_FIELD");
        }
    }

    @Test
    public void testSetDynamicNonDbAttributes() {
        HybridEntity1 entity1 = this.context.newObject(HybridEntity1.class);
        entity1.writeProperty("CUSTOM_NON_DB_ATTRIBUTE", 42L);
        Assert.assertEquals((Object)42L, (Object)entity1.readProperty("CUSTOM_NON_DB_ATTRIBUTE"));
        Assert.assertNotNull((Object)entity1.values);
        this.context.commitChanges();
        entity1.writeProperty("CUSTOM_NON_DB_ATTRIBUTE", 12L);
        HybridEntity1 selectEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(this.context);
        Assert.assertEquals((Object)12L, (Object)selectEntity1.readProperty("CUSTOM_NON_DB_ATTRIBUTE"));
        ObjectContext cleanContext = this.runtime.newContext();
        HybridEntity1 selectCleanEntity1 = (HybridEntity1)ObjectSelect.query(HybridEntity1.class).selectOne(cleanContext);
        Assert.assertEquals(null, (Object)selectCleanEntity1.readProperty("CUSTOM_NON_DB_ATTRIBUTE"));
    }

    @Test
    public void testSerialization() throws Exception {
        HybridEntity1 entity1 = new HybridEntity1();
        entity1.setIntField(123);
        entity1.setStrField("abc");
        entity1.writeProperty("CUSTOM_PROPERTY", 3.14);
        HybridEntity1 clonedEntity1 = Util.cloneViaSerialization(entity1);
        Assert.assertEquals((long)123L, (long)clonedEntity1.getIntField());
        Assert.assertEquals((Object)"abc", (Object)clonedEntity1.getStrField());
        Assert.assertEquals((Object)3.14, (Object)clonedEntity1.readProperty("CUSTOM_PROPERTY"));
    }

    @Test
    public void testDirectPropertyWrite() throws Exception {
        HybridEntity1 entity1 = new HybridEntity1();
        HybridEntity2 entity2 = new HybridEntity2();
        entity2.writePropertyDirectly("intField", 123);
        entity2.writePropertyDirectly("strField", "abc");
        Assert.assertNull((Object)entity2.values);
        entity2.writePropertyDirectly("CUSTOM_PROPERTY", 3.14);
        entity2.writePropertyDirectly("hybridEntity1", entity1);
        Assert.assertNotNull((Object)entity2.values);
        Assert.assertEquals((Object)123, (Object)entity2.readPropertyDirectly("intField"));
        Assert.assertEquals((Object)"abc", (Object)entity2.readPropertyDirectly("strField"));
        Assert.assertEquals((Object)3.14, (Object)entity2.readPropertyDirectly("CUSTOM_PROPERTY"));
        Assert.assertEquals((Object)entity1, (Object)entity2.readPropertyDirectly("hybridEntity1"));
    }

    private void addRuntimeAttribute(Class<?> entityClass, String attributeName, String attributeType) {
        ObjEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(entityClass);
        ObjAttribute attribute = new ObjAttribute();
        attribute.setName(attributeName);
        attribute.setDbAttributePath(attributeName);
        attribute.setType(attributeType);
        entity.addAttribute(attribute);
    }

    private void removeRuntimeAttribute(Class<?> entityClass, String attributeName) {
        ObjEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(entityClass);
        entity.removeAttribute(attributeName);
    }
}

