/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Fault;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.testdo.relationships_to_one_fk.ToOneFK1;
import org.apache.cayenne.testdo.relationships_to_one_fk.ToOneFK2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-to-one-fk.xml")
public class CDOOneToOneFKIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;

    @Test
    public void testReadRelationship() {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        ToOneFK1 target = this.context.newObject(ToOneFK1.class);
        src.setToOneToFK(target);
        this.context.commitChanges();
        this.context.invalidateObjects(src, target);
        ToOneFK2 src1 = (ToOneFK2)Cayenne.objectForPK(this.context, src.getObjectId());
        Assert.assertNotNull((Object)src1.getToOneToFK());
        Assert.assertSame((Object)src1, (Object)src1.getToOneToFK().getToPK());
        this.context.invalidateObjects(src1, src1.getToOneToFK());
        ToOneFK1 target2 = (ToOneFK1)Cayenne.objectForPK(this.context, target.getObjectId());
        Assert.assertNotNull((Object)target2.getToPK());
        Assert.assertSame((Object)target2, (Object)target2.getToPK().getToOneToFK());
    }

    @Test
    public void test2Null() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        Assert.assertNull((Object)src2.getToOneToFK());
    }

    @Test
    public void testReplaceNull1() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        Assert.assertEquals((Object)src.getObjectId(), (Object)src2.getObjectId());
        src2.setToOneToFK(null);
        Assert.assertNull((Object)src2.getToOneToFK());
    }

    @Test
    public void testReplaceNull2() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        this.context.commitChanges();
        ToOneFK1 target = this.context.newObject(ToOneFK1.class);
        src.setToOneToFK(target);
        Assert.assertSame((Object)target, (Object)src.getToOneToFK());
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        ToOneFK1 target2 = src2.getToOneToFK();
        Assert.assertNotNull((Object)target2);
        Assert.assertEquals((Object)src.getObjectId(), (Object)src2.getObjectId());
        Assert.assertEquals((Object)target.getObjectId(), (Object)target2.getObjectId());
    }

    @Test
    public void testNewAdd() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        ToOneFK1 target = this.context.newObject(ToOneFK1.class);
        src.setToOneToFK(target);
        Assert.assertSame((Object)target, (Object)src.getToOneToFK());
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        ToOneFK1 target2 = src2.getToOneToFK();
        Assert.assertNotNull((Object)target2);
        Assert.assertEquals((Object)src.getObjectId(), (Object)src2.getObjectId());
        Assert.assertEquals((Object)target.getObjectId(), (Object)target2.getObjectId());
    }

    @Test
    public void testTakeObjectSnapshotDependentFault() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        ToOneFK1 target = this.context.newObject(ToOneFK1.class);
        src.setToOneToFK(target);
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        Assert.assertTrue((boolean)(src2.readPropertyDirectly("toOneToFK") instanceof Fault));
        this.context.currentSnapshot(src2);
        Assert.assertTrue((boolean)(src2.readPropertyDirectly("toOneToFK") instanceof Fault));
    }

    @Test
    public void testDelete() throws Exception {
        ToOneFK2 src = this.context.newObject(ToOneFK2.class);
        ToOneFK1 target = this.context.newObject(ToOneFK1.class);
        src.setToOneToFK(target);
        this.context.commitChanges();
        src.setToOneToFK(null);
        this.context.deleteObjects(target);
        this.context.commitChanges();
        ObjectIdQuery refetch = new ObjectIdQuery(src.getObjectId(), false, 2);
        ToOneFK2 src2 = (ToOneFK2)Cayenne.objectForQuery(this.context1, refetch);
        Assert.assertNull((Object)src.getToOneToFK());
        Assert.assertEquals((Object)src.getObjectId(), (Object)src2.getObjectId());
    }
}

