/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class FloatType
implements ExtendedType<Float> {
    @Override
    public String getClassName() {
        return Float.class.getName();
    }

    @Override
    public Float materializeObject(ResultSet rs, int index, int type) throws Exception {
        float f = rs.getFloat(index);
        return rs.wasNull() ? null : Float.valueOf(f);
    }

    @Override
    public Float materializeObject(CallableStatement rs, int index, int type) throws Exception {
        float f = rs.getFloat(index);
        return rs.wasNull() ? null : Float.valueOf(f);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Float value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setFloat(pos, value.floatValue());
        }
    }

    @Override
    public String toString(Float value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

