/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.jira;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships.ReflexiveAndToOne;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships.xml")
public class CAY_194IT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper tReflexive = new TableHelper(this.dbHelper, "REFLEXIVE_AND_TO_ONE");
        tReflexive.setColumns(new String[]{"REFLEXIVE_AND_TO_ONE_ID", "PARENT_ID"});
        tReflexive.update().set("PARENT_ID", null, 4).execute();
        this.dbHelper.deleteAll("REFLEXIVE_AND_TO_ONE");
    }

    @Test
    public void testQualifyOnToMany() {
        ReflexiveAndToOne ox = this.context.newObject(ReflexiveAndToOne.class);
        ox.setName("ox");
        ReflexiveAndToOne o1 = this.context.newObject(ReflexiveAndToOne.class);
        o1.setName("o1");
        ReflexiveAndToOne o2 = this.context.newObject(ReflexiveAndToOne.class);
        o2.setName("o2");
        o2.setToParent(o1);
        this.context.commitChanges();
        Expression qualifier = ExpressionFactory.matchExp("children", (Object)o2);
        List<ReflexiveAndToOne> parents = SelectQuery.query(ReflexiveAndToOne.class, qualifier).select(this.context);
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertSame((Object)o1, (Object)parents.get(0));
        qualifier = ExpressionFactory.matchExp("children", (Object)o1);
        parents = SelectQuery.query(ReflexiveAndToOne.class, qualifier).select(this.context);
        Assert.assertEquals((long)0L, (long)parents.size());
    }

    @Test
    public void testQualifyOnToOne() {
        ReflexiveAndToOne ox = this.context.newObject(ReflexiveAndToOne.class);
        ox.setName("ox");
        ReflexiveAndToOne o1 = this.context.newObject(ReflexiveAndToOne.class);
        o1.setName("o1");
        ReflexiveAndToOne o2 = this.context.newObject(ReflexiveAndToOne.class);
        o2.setName("o2");
        o2.setToParent(o1);
        this.context.commitChanges();
        Expression qualifier = ExpressionFactory.matchExp("toParent", (Object)o1);
        List<ReflexiveAndToOne> children = SelectQuery.query(ReflexiveAndToOne.class, qualifier).select(this.context);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertSame((Object)o2, (Object)children.get(0));
        o2.setToParent(null);
        this.context.commitChanges();
    }
}

