/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.jira;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_clob.ClobMaster;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-clob.xml")
public class CAY_115IT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected UnitDbAdapter accessStackAdapter;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tClobMaster;
    protected TableHelper tClobDetail;

    @Before
    public void setUp() throws Exception {
        this.tClobMaster = new TableHelper(this.dbHelper, "CLOB_MASTER");
        this.tClobMaster.setColumns(new String[]{"CLOB_MASTER_ID", "CLOB_COLUMN", "NAME"});
        this.tClobDetail = new TableHelper(this.dbHelper, "CLOB_DETAIL");
        this.tClobDetail.setColumns(new String[]{"CLOB_DETAIL_ID", "CLOB_MASTER_ID", "NAME"});
    }

    protected void createDistinctClobFetchDataSet() throws Exception {
        this.tClobMaster.insert(new Object[]{1, "cm1 clob", "cm1"});
        this.tClobMaster.insert(new Object[]{2, "cm2 clob", "cm2"});
        this.tClobMaster.insert(new Object[]{3, "cm3 clob", "cm3"});
    }

    protected void createDistinctClobFetchWithToManyJoin() throws Exception {
        this.tClobMaster.insert(new Object[]{1, "cm1 clob", "cm1"});
        this.tClobMaster.insert(new Object[]{2, "cm2 clob", "cm2"});
        this.tClobMaster.insert(new Object[]{3, "cm3 clob", "cm3"});
        this.tClobDetail.insert(new Object[]{1, 1, "cd11"});
        this.tClobDetail.insert(new Object[]{2, 2, "cd21"});
        this.tClobDetail.insert(new Object[]{3, 2, "cd22"});
        this.tClobDetail.insert(new Object[]{4, 3, "cd31"});
    }

    @Test
    public void testDistinctClobFetch() throws Exception {
        if (!this.accessStackAdapter.supportsLobInsertsAsStrings()) {
            return;
        }
        this.createDistinctClobFetchDataSet();
        SelectQuery<ClobMaster> noDistinct = new SelectQuery<ClobMaster>(ClobMaster.class);
        noDistinct.addOrdering(ClobMaster.NAME.asc());
        SelectQuery<ClobMaster> distinct = new SelectQuery<ClobMaster>(ClobMaster.class);
        distinct.setDistinct(true);
        distinct.addOrdering(ClobMaster.NAME.asc());
        List noDistinctResult = this.context.performQuery(noDistinct);
        List distinctResult = this.context.performQuery(distinct);
        Assert.assertEquals((long)3L, (long)noDistinctResult.size());
        Assert.assertEquals((Object)noDistinctResult, (Object)distinctResult);
    }

    @Test
    public void testDistinctClobFetchWithToManyJoin() throws Exception {
        if (!this.accessStackAdapter.supportsLobInsertsAsStrings()) {
            return;
        }
        this.createDistinctClobFetchWithToManyJoin();
        Expression qual = ExpressionFactory.exp("details.name like 'cd%'", new Object[0]);
        SelectQuery<ClobMaster> query = new SelectQuery<ClobMaster>(ClobMaster.class, qual);
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)result.size());
    }
}

