/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.map.DataMap;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDataChannelDescriptorMergerTest {
    @Test
    public void testSingleDescriptor() {
        DataChannelDescriptor descriptor = new DataChannelDescriptor();
        descriptor.setName("Zx");
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(descriptor);
        Assert.assertSame((Object)descriptor, (Object)merged);
        Assert.assertEquals((Object)"Zx", (Object)merged.getName());
    }

    @Test
    public void testMerged_Name() {
        DataChannelDescriptor d1 = new DataChannelDescriptor();
        d1.setName("Zx");
        DataChannelDescriptor d2 = new DataChannelDescriptor();
        d2.setName("Ym");
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(d1, d2);
        Assert.assertNotSame((Object)d1, (Object)merged);
        Assert.assertNotSame((Object)d2, (Object)merged);
        Assert.assertEquals((Object)"Ym", (Object)merged.getName());
    }

    @Test
    public void testMerged_Properties() {
        DataChannelDescriptor d1 = new DataChannelDescriptor();
        d1.getProperties().put("X", "1");
        d1.getProperties().put("Y", "2");
        DataChannelDescriptor d2 = new DataChannelDescriptor();
        d2.getProperties().put("X", "3");
        d2.getProperties().put("Z", "4");
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(d1, d2);
        Assert.assertEquals((long)2L, (long)merged.getProperties().size());
        Assert.assertEquals((Object)"3", (Object)merged.getProperties().get("X"));
        Assert.assertEquals((Object)"4", (Object)merged.getProperties().get("Z"));
    }

    @Test
    public void testMerged_DataMaps() {
        DataChannelDescriptor d1 = new DataChannelDescriptor();
        d1.setName("Zx");
        DataMap m11 = new DataMap("A");
        DataMap m12 = new DataMap("B");
        d1.getDataMaps().add(m11);
        d1.getDataMaps().add(m12);
        DataChannelDescriptor d2 = new DataChannelDescriptor();
        d2.setName("Ym");
        DataMap m21 = new DataMap("C");
        DataMap m22 = new DataMap("A");
        d2.getDataMaps().add(m21);
        d2.getDataMaps().add(m22);
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(d1, d2);
        Assert.assertEquals((long)3L, (long)merged.getDataMaps().size());
        Assert.assertSame((Object)m22, (Object)merged.getDataMap("A"));
        Assert.assertSame((Object)m12, (Object)merged.getDataMap("B"));
        Assert.assertSame((Object)m21, (Object)merged.getDataMap("C"));
    }

    @Test
    public void testMerge_DataNodes() {
        DataChannelDescriptor d1 = new DataChannelDescriptor();
        d1.setName("Zx");
        DataNodeDescriptor dn11 = new DataNodeDescriptor("A");
        DataNodeDescriptor dn12 = new DataNodeDescriptor("B");
        dn12.setAdapterType("Xa");
        d1.getNodeDescriptors().add(dn11);
        d1.getNodeDescriptors().add(dn12);
        DataChannelDescriptor d2 = new DataChannelDescriptor();
        d2.setName("Ym");
        DataNodeDescriptor dn21 = new DataNodeDescriptor("B");
        dn21.setAdapterType("Uy");
        DataNodeDescriptor dn22 = new DataNodeDescriptor("C");
        d2.getNodeDescriptors().add(dn21);
        d2.getNodeDescriptors().add(dn22);
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(d1, d2);
        Assert.assertEquals((long)3L, (long)merged.getNodeDescriptors().size());
        DataNodeDescriptor mergedA = merged.getNodeDescriptor("A");
        Assert.assertNotNull((Object)mergedA);
        Assert.assertNotSame((Object)dn11, (Object)mergedA);
        DataNodeDescriptor mergedB = merged.getNodeDescriptor("B");
        Assert.assertNotNull((Object)mergedB);
        Assert.assertNotSame((Object)dn12, (Object)mergedB);
        Assert.assertNotSame((Object)dn21, (Object)mergedB);
        Assert.assertEquals((Object)"Uy", (Object)mergedB.getAdapterType());
        DataNodeDescriptor mergedC = merged.getNodeDescriptor("C");
        Assert.assertNotNull((Object)mergedC);
        Assert.assertNotSame((Object)dn22, (Object)mergedC);
    }

    @Test
    public void testMerge_DataNodesMapLinks() {
        DataChannelDescriptor d1 = new DataChannelDescriptor();
        d1.setName("Zx");
        DataNodeDescriptor dn11 = new DataNodeDescriptor("A");
        dn11.getDataMapNames().add("MA");
        dn11.getDataMapNames().add("MB");
        d1.getNodeDescriptors().add(dn11);
        DataChannelDescriptor d2 = new DataChannelDescriptor();
        d2.setName("Ym");
        DataNodeDescriptor dn21 = new DataNodeDescriptor("A");
        dn21.getDataMapNames().add("MA");
        dn21.getDataMapNames().add("MC");
        d2.getNodeDescriptors().add(dn21);
        DefaultDataChannelDescriptorMerger merger = new DefaultDataChannelDescriptorMerger();
        DataChannelDescriptor merged = merger.merge(d1, d2);
        Assert.assertEquals((long)1L, (long)merged.getNodeDescriptors().size());
        DataNodeDescriptor mergedA = merged.getNodeDescriptor("A");
        Assert.assertNotNull((Object)mergedA);
        Assert.assertNotSame((Object)dn11, (Object)mergedA);
        Assert.assertNotSame((Object)dn21, (Object)mergedA);
        Assert.assertEquals((long)3L, (long)mergedA.getDataMapNames().size());
        Assert.assertTrue((boolean)mergedA.getDataMapNames().contains("MA"));
        Assert.assertTrue((boolean)mergedA.getDataMapNames().contains("MB"));
        Assert.assertTrue((boolean)mergedA.getDataMapNames().contains("MC"));
    }
}

