/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.primitive.PrimitivesTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-primitive.xml")
public class PrimitiveAttributesIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void testCommit() {
        PrimitivesTestEntity e = this.context.newObject(PrimitivesTestEntity.class);
        e.setBooleanColumn(true);
        e.setIntColumn(88);
        e.setCharColumn('B');
        this.context.commitChanges();
    }

    @Test
    public void testSelect() throws Exception {
        TableHelper tPrimitives = new TableHelper(this.dbHelper, "PRIMITIVES_TEST");
        tPrimitives.setColumns(new String[]{"ID", "BOOLEAN_COLUMN", "INT_COLUMN", "CHAR_COLUMN"});
        tPrimitives.insert(new Object[]{1, true, -100, String.valueOf('a')}).insert(new Object[]{2, false, 0, String.valueOf('~')}).insert(new Object[]{3, true, Integer.MAX_VALUE, String.valueOf('Z')});
        List result = ObjectSelect.query(PrimitivesTestEntity.class).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).select(this.context);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)-100L, (long)((PrimitivesTestEntity)result.get(0)).getIntColumn());
        Assert.assertEquals((long)97L, (long)((PrimitivesTestEntity)result.get(0)).getCharColumn());
        Assert.assertTrue((boolean)((PrimitivesTestEntity)result.get(0)).isBooleanColumn());
        Assert.assertEquals((long)0L, (long)((PrimitivesTestEntity)result.get(1)).getIntColumn());
        Assert.assertEquals((long)126L, (long)((PrimitivesTestEntity)result.get(1)).getCharColumn());
        Assert.assertFalse((boolean)((PrimitivesTestEntity)result.get(1)).isBooleanColumn());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((PrimitivesTestEntity)result.get(2)).getIntColumn());
        Assert.assertEquals((long)90L, (long)((PrimitivesTestEntity)result.get(2)).getCharColumn());
        Assert.assertTrue((boolean)((PrimitivesTestEntity)result.get(2)).isBooleanColumn());
    }
}

