/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.WeakValueMap;
import org.junit.Assert;
import org.junit.Test;

public class WeakValueMapTest {
    @Test
    public void testEmptyConstructor() {
        WeakValueMap map = new WeakValueMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("nonexistent_key1"));
        Assert.assertFalse((boolean)map.containsValue(42));
        Assert.assertNull(map.get("nonexistent_key2"));
        Assert.assertEquals((Object)42, (Object)map.getOrDefault("nonexistent_key2", 42));
        Assert.assertEquals((long)0L, (long)map.values().size());
        Assert.assertEquals((long)0L, (long)map.keySet().size());
        Assert.assertEquals((long)0L, (long)map.entrySet().size());
    }

    @Test
    public void testCapacityConstructor() {
        WeakValueMap map = new WeakValueMap(42);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("nonexistent_key1"));
        Assert.assertFalse((boolean)map.containsValue(42));
        Assert.assertNull(map.get("nonexistent_key2"));
        Assert.assertEquals((Object)42, (Object)map.getOrDefault("nonexistent_key2", 42));
        Assert.assertEquals((long)0L, (long)map.values().size());
        Assert.assertEquals((long)0L, (long)map.keySet().size());
        Assert.assertEquals((long)0L, (long)map.entrySet().size());
    }

    @Test
    public void testMapConstructor() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("key_1", 123);
        data.put("key_2", 42);
        data.put("key_3", 543);
        WeakValueMap map = new WeakValueMap(data);
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((long)data.size(), (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("nonexistent_key1"));
        Assert.assertTrue((boolean)map.containsKey("key_3"));
        Assert.assertFalse((boolean)map.containsValue(321));
        Assert.assertTrue((boolean)map.containsValue(42));
        Assert.assertNull(map.get("nonexistent_key2"));
        Assert.assertEquals((Object)543, map.get("key_3"));
        Assert.assertEquals((Object)123, (Object)map.getOrDefault("key_1", 42));
        Assert.assertEquals((long)data.size(), (long)map.values().size());
        Assert.assertEquals((long)data.size(), (long)map.keySet().size());
        Assert.assertEquals((long)data.size(), (long)map.entrySet().size());
        Assert.assertTrue((boolean)map.values().containsAll(data.values()));
        Assert.assertTrue((boolean)map.keySet().containsAll(data.keySet()));
        Assert.assertTrue((boolean)map.entrySet().containsAll(data.entrySet()));
    }

    @Test
    public void testSimpleOperations() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("key_1", 123);
        data.put("key_2", 42);
        data.put("key_3", 543);
        WeakValueMap<String, Integer> map = new WeakValueMap<String, Integer>(data);
        map.put("key_4", 44);
        Assert.assertEquals((Object)44, map.get("key_4"));
        Assert.assertEquals((long)4L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("key_4"));
        Assert.assertTrue((boolean)map.containsValue(44));
        int old = (Integer)map.remove("key_4");
        Assert.assertEquals((long)44L, (long)old);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("key_4"));
        Assert.assertFalse((boolean)map.containsValue(44));
    }

    @Test
    public void testEntrySetUpdateValue() {
        WeakValueMap<String, Integer> map = new WeakValueMap<String, Integer>();
        map.put("key_1", 123);
        map.put("key_2", 42);
        map.put("key_3", 543);
        Assert.assertEquals((long)3L, (long)map.size());
        int counter = 0;
        for (Map.Entry entry : map.entrySet()) {
            if ("key_2".equals(entry.getKey())) {
                int old = entry.setValue(24);
                Assert.assertEquals((long)42L, (long)old);
            }
            ++counter;
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((Object)24, map.get("key_2"));
    }

    @Test
    public void testSerializationSupport() throws Exception {
        WeakValueMap map = new WeakValueMap();
        Integer val1 = 543;
        TestSerializable val2 = new TestSerializable();
        map.put("key_1", (Object)123);
        map.put("key_2", (Object)42);
        map.put("key_3", val1);
        map.put("key_4", val2);
        Assert.assertEquals((long)4L, (long)map.size());
        WeakValueMap clone = Util.cloneViaSerialization(map);
        Assert.assertEquals((long)4L, (long)clone.size());
        Assert.assertEquals((Object)42, (Object)clone.get("key_2"));
        Assert.assertTrue((boolean)clone.containsKey("key_3"));
        Assert.assertTrue((boolean)clone.containsValue(123));
        Assert.assertTrue((boolean)clone.containsKey("key_4"));
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        WeakValueMap<String, Integer> map1 = new WeakValueMap<String, Integer>();
        map1.put("key_1", 123);
        map1.put("key_2", 42);
        map1.put("key_3", 543);
        Assert.assertEquals((long)3L, (long)map1.size());
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("key_1", 123);
        map2.put("key_2", 42);
        map2.put("key_3", 543);
        Assert.assertEquals(map1, map2);
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModification() {
        WeakValueMap<String, Integer> map = new WeakValueMap<String, Integer>(3);
        map.put("key_1", 123);
        map.put("key_2", 42);
        map.put("key_3", 543);
        map.put("key_4", 321);
        Assert.assertEquals((long)4L, (long)map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (!"key_2".equals(entry.getKey())) continue;
            map.remove("key_2");
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedEntryIteratorRemoval() {
        WeakValueMap<String, Integer> map = new WeakValueMap<String, Integer>(3);
        map.put("key_1", 123);
        map.put("key_2", 42);
        map.put("key_3", 543);
        Assert.assertEquals((long)3L, (long)map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testPutNullValue() {
        WeakValueMap<String, Object> map = new WeakValueMap<String, Object>();
        map.put("1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testPutAllNullValue() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("123", null);
        WeakValueMap<String, Object> map = new WeakValueMap<String, Object>();
        map.putAll(values);
    }

    static class TestSerializable
    implements Serializable {
        private static final long serialVersionUID = -8726479278547192134L;

        TestSerializable() {
        }
    }
}

