/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di;

import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.DefaultScope;
import org.apache.cayenne.unit.di.DICase;
import org.apache.cayenne.unit.di.DefaultUnitTestLifecycleManager;
import org.apache.cayenne.unit.di.UnitTestLifecycleManager;
import org.junit.Assert;
import org.junit.Test;

public class DICaseSelfIT
extends DICase {
    private static final Injector injector;
    @Inject(value="test-scope")
    protected Object testScoped;
    @Inject(value="singleton-scope")
    protected Object singletonScoped;

    @Override
    protected Injector getUnitTestInjector() {
        return injector;
    }

    @Test
    public void testInjection() throws Exception {
        Object testScoped = this.testScoped;
        Assert.assertNotNull((Object)testScoped);
        Object singletonScoped = this.singletonScoped;
        Assert.assertNotNull((Object)singletonScoped);
        this.tearDownLifecycleManager();
        this.setUpLifecycleManager();
        Assert.assertNotSame((Object)testScoped, (Object)this.testScoped);
        Assert.assertNotNull((Object)this.testScoped);
        Assert.assertSame((Object)singletonScoped, (Object)this.singletonScoped);
    }

    static {
        Module selfTestModule = binder -> {
            DefaultScope testScope = new DefaultScope(new Class[0]);
            binder.bind(UnitTestLifecycleManager.class).toInstance((Object)new DefaultUnitTestLifecycleManager(testScope));
            binder.bind(Key.get(Object.class, (String)"test-scope")).to(Object.class).in((Scope)testScope);
            binder.bind(Key.get(Object.class, (String)"singleton-scope")).to(Object.class).inSingletonScope();
        };
        injector = DIBootstrap.createInjector((Module[])new Module[]{selfTestModule});
    }
}

