/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitDbAdapter {
    private static final Logger logger = LoggerFactory.getLogger(UnitDbAdapter.class);
    @Inject
    protected RuntimeProperties runtimeProperties;
    protected DbAdapter adapter;

    public UnitDbAdapter(DbAdapter adapter) {
        if (adapter == null) {
            throw new CayenneRuntimeException("Null adapter.", new Object[0]);
        }
        this.adapter = adapter;
    }

    public boolean supportsPKGeneratorConcurrency() {
        return true;
    }

    public String getIdentifiersStartQuote() {
        return "\"";
    }

    public String getIdentifiersEndQuote() {
        return "\"";
    }

    public boolean realAsDouble() {
        return false;
    }

    public void willDropTables(Connection conn, DataMap map, Collection<String> tablesToDrop) throws Exception {
        this.dropConstraints(conn, map, tablesToDrop);
    }

    protected void dropConstraints(Connection conn, DataMap map, Collection<String> tablesToDrop) throws Exception {
        Map<String, Collection<String>> constraintsMap = this.getConstraints(conn, map, tablesToDrop);
        for (Map.Entry<String, Collection<String>> entry : constraintsMap.entrySet()) {
            String tableName;
            DbEntity entity;
            Collection<String> constraints = entry.getValue();
            if (constraints == null || constraints.isEmpty() || (entity = map.getDbEntity((tableName = entry.getKey()).toString())) == null) continue;
            QuotingStrategy strategy = this.adapter.getQuotingStrategy();
            for (String constraint : constraints) {
                StringBuilder drop = new StringBuilder();
                drop.append("ALTER TABLE ").append(strategy.quotedFullyQualifiedName(entity)).append(" DROP CONSTRAINT ").append(constraint);
                this.executeDDL(conn, drop.toString());
            }
        }
    }

    public void droppedTables(Connection con, DataMap map) throws Exception {
    }

    public void tweakProcedure(Procedure proc) {
    }

    public void willCreateTables(Connection con, DataMap map) throws Exception {
    }

    public void createdTables(Connection con, DataMap map) throws Exception {
    }

    public boolean supportsStoredProcedures() {
        return false;
    }

    public boolean supportsReverseComparison() {
        return true;
    }

    public boolean supportNullRowForAggregateFunctions() {
        return true;
    }

    public boolean supportsEqualNullSyntax() {
        return true;
    }

    public boolean supportsAllAnySome() {
        return true;
    }

    public boolean supportsTrimChar() {
        return false;
    }

    public boolean canMakeObjectsOutOfProcedures() {
        return this.supportsStoredProcedures();
    }

    public boolean supportsLobInsertsAsStrings() {
        return this.supportsLobs();
    }

    public boolean supportsFKConstraints(DbEntity entity) {
        return !"FK_OF_DIFFERENT_TYPE".equals(entity.getName());
    }

    public boolean supportsFKConstraints() {
        return true;
    }

    public boolean supportsColumnTypeReengineering() {
        return true;
    }

    public boolean supportsLobs() {
        return false;
    }

    public boolean supportsLobComparisons() {
        return this.supportsLobs();
    }

    public boolean supportsBinaryPK() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsCaseSensitiveLike() {
        return !this.runtimeProperties.getBoolean("cayenne.runtime.db.collation.assume.ci", false);
    }

    public boolean supportsCaseInsensitiveOrder() {
        return true;
    }

    public boolean supportsCatalogs() {
        return false;
    }

    public boolean supportsBatchPK() {
        return true;
    }

    public boolean supportsBitwiseOps() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDDL(Connection con, String ddl) throws Exception {
        logger.info(ddl);
        try (Statement st = con.createStatement();){
            st.execute(ddl);
        }
    }

    protected void executeDDL(Connection con, String database, String name) throws Exception {
        this.executeDDL(con, this.ddlString(database, name));
    }

    private String ddlString(String database, String name) {
        StringBuffer location = new StringBuffer();
        location.append("ddl/").append(database).append("/").append(name);
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(location.toString());
        if (resource == null) {
            throw new CayenneRuntimeException("Can't find DDL file: " + location, new Object[0]);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resource));
        StringBuffer buf = new StringBuffer();
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line).append('\n');
            }
        }
        catch (IOException e) {
            throw new CayenneRuntimeException("Error reading DDL file: " + location, new Object[0]);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return buf.toString();
    }

    public boolean handlesNullVsEmptyLOBs() {
        return this.supportsLobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Collection<String>> getConstraints(Connection conn, DataMap map, Collection<String> includeTables) throws SQLException {
        HashMap<String, Collection<String>> constraintMap = new HashMap<String, Collection<String>>();
        DatabaseMetaData metadata = conn.getMetaData();
        for (String name : includeTables) {
            DbEntity entity = map.getDbEntity(name);
            if (entity == null) continue;
            QuotingStrategy strategy = this.adapter.getQuotingStrategy();
            try (ResultSet rs = metadata.getExportedKeys(entity.getCatalog(), entity.getSchema(), entity.getName());){
                while (rs.next()) {
                    String fk = rs.getString("FK_NAME");
                    String fkTable = rs.getString("FKTABLE_NAME");
                    if (fk == null || fkTable == null) continue;
                    HashSet<String> constraints = (HashSet<String>)constraintMap.get(fkTable);
                    if (constraints == null) {
                        constraints = new HashSet<String>();
                        constraintMap.put(fkTable, constraints);
                    }
                    constraints.add(strategy.quotedIdentifier(entity, fk));
                }
            }
        }
        return constraintMap;
    }

    public boolean isLowerCaseNames() {
        return false;
    }

    public boolean onlyGenericNumberType() {
        return false;
    }

    public boolean supportsTimeSqlType() {
        return true;
    }

    public boolean onlyGenericDateType() {
        return false;
    }

    public boolean supportsNullBoolean() {
        return true;
    }

    public boolean supportsBoolean() {
        return true;
    }

    public boolean supportsGeneratedKeys() {
        return this.adapter.supportsGeneratedKeys();
    }

    public boolean supportsGeneratedKeysAdd() {
        return false;
    }

    public boolean supportsGeneratedKeysDrop() {
        return false;
    }

    public boolean supportsEscapeInLike() {
        return true;
    }

    public boolean supportsExpressionInHaving() {
        return true;
    }

    public boolean supportsSelectBooleanExpression() {
        return true;
    }

    public boolean supportsExtractPart(ASTExtract.DateTimePart part) {
        return true;
    }

    public boolean supportsSerializableTransactionIsolation() {
        return false;
    }

    public boolean supportsLongIn() {
        return true;
    }
}

