/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataObjectDescriptorFactoryIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testVisitDeclaredProperties_IterationOrder() {
        DataObjectDescriptorFactory factory = new DataObjectDescriptorFactory(this.resolver.getClassDescriptorMap(), new SingletonFaultFactory());
        for (ObjEntity e : this.resolver.getObjEntities()) {
            ClassDescriptor descriptor = factory.getDescriptor(e.getName());
            final PropertyDescriptor[] lastProcessed = new PropertyDescriptor[1];
            PropertyVisitor visitor = new PropertyVisitor(){

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }
            };
            descriptor.visitDeclaredProperties(visitor);
        }
    }

    @Test
    public void testVisitProperties_IterationOrder() {
        DataObjectDescriptorFactory factory = new DataObjectDescriptorFactory(this.resolver.getClassDescriptorMap(), new SingletonFaultFactory());
        for (ObjEntity e : this.resolver.getObjEntities()) {
            ClassDescriptor descriptor = factory.getDescriptor(e.getName());
            final PropertyDescriptor[] lastProcessed = new PropertyDescriptor[1];
            PropertyVisitor visitor = new PropertyVisitor(){

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }
            };
            descriptor.visitProperties(visitor);
        }
    }

    static void assertPropertiesAreInOrder(PropertyDescriptor o1, PropertyDescriptor o2) {
        if (o1 == null) {
            return;
        }
        if (o1 instanceof ArcProperty) {
            if (o2 instanceof ArcProperty) {
                Assert.assertTrue((String)("Names are not ordered: " + o1.getName() + " before " + o2.getName()), (o1.getName().compareTo(o2.getName()) < 0 ? 1 : 0) != 0);
            } else {
                Assert.fail((String)"Arc preceded regular property");
            }
        } else if (!(o2 instanceof ArcProperty)) {
            Assert.assertTrue((String)("Names are not ordered: " + o1.getName() + " before " + o2.getName()), (o1.getName().compareTo(o2.getName()) < 0 ? 1 : 0) != 0);
        }
    }
}

