/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.SimpleAttributeProperty;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PersistentDescriptorTest {
    @Test
    public void testConstructor() {
        PersistentDescriptor d1 = new PersistentDescriptor();
        Assert.assertNull((Object)d1.getSuperclassDescriptor());
        PersistentDescriptor d2 = new PersistentDescriptor();
        d2.setSuperclassDescriptor(d1);
        Assert.assertNull((Object)d1.getSuperclassDescriptor());
        Assert.assertSame((Object)d1, (Object)d2.getSuperclassDescriptor());
    }

    @Test
    public void testCopyObjectProperties() {
        PersistentDescriptor d1 = new PersistentDescriptor();
        ObjAttribute attribute = (ObjAttribute)Mockito.mock(ObjAttribute.class);
        FieldAccessor accessor = new FieldAccessor(TstBean.class, "string", String.class);
        SimpleAttributeProperty property = new SimpleAttributeProperty(d1, accessor, attribute);
        d1.addDeclaredProperty(property);
        TstBean from = new TstBean();
        from.setString("123");
        TstBean to = new TstBean();
        d1.shallowMerge(from, to);
        Assert.assertEquals((Object)"123", (Object)to.getString());
    }
}

