/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.TstFields;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessorTest {
    @Test
    public void testConstructor() {
        FieldAccessor accessor = new FieldAccessor(TstBean.class, "string", String.class);
        Assert.assertEquals((Object)"string", (Object)accessor.getName());
    }

    @Test
    public void testGet() {
        FieldAccessor accessor = new FieldAccessor(TstBean.class, "string", String.class);
        TstBean object = new TstBean();
        object.setString("abc");
        Assert.assertEquals((Object)"abc", (Object)accessor.getValue(object));
    }

    @Test
    public void testSetValue() {
        TstFields object = new TstFields();
        new FieldAccessor(TstFields.class, "stringField", String.class).setValue(object, "aaa");
        Assert.assertEquals((Object)"aaa", (Object)object.stringField);
        byte[] bytes = new byte[]{1, 2, 3};
        new FieldAccessor(TstFields.class, "byteArrayField", byte[].class).setValue(object, bytes);
        Assert.assertSame((Object)bytes, (Object)object.byteArrayField);
        String[] strings = new String[]{"a", "b"};
        new FieldAccessor(TstFields.class, "stringArrayField", String[].class).setValue(object, strings);
        Assert.assertSame((Object)strings, (Object)object.stringArrayField);
    }

    @Test
    public void testSetValuePrimitive() {
        TstFields object = new TstFields();
        new FieldAccessor(TstFields.class, "intField", Integer.TYPE).setValue(object, new Integer(6));
        Assert.assertEquals((long)6L, (long)object.intField);
        object.intField = 55;
        new FieldAccessor(TstFields.class, "intField", Integer.TYPE).setValue(object, null);
        Assert.assertEquals((long)0L, (long)object.intField);
    }
}

