/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.map.MockCallingBackEntity;
import org.apache.cayenne.reflect.CallbackOnEntity;
import org.junit.Assert;
import org.junit.Test;

public class CallbackOnEntityTest {
    @Test
    public void testPublicCallbackMethod() {
        CallbackOnEntity callback = new CallbackOnEntity(MockCallingBackEntity.class, "publicCallback");
        MockCallingBackEntity e = new MockCallingBackEntity();
        callback.performCallback(e);
        Assert.assertTrue((boolean)e.publicCallbackInvoked);
        Assert.assertFalse((boolean)e.protectedCallbackInvoked);
        Assert.assertFalse((boolean)e.privateCallbackInvoked);
        Assert.assertFalse((boolean)e.defaultCallbackInvoked);
    }

    @Test
    public void testProtectedCallbackMethod() {
        CallbackOnEntity callback = new CallbackOnEntity(MockCallingBackEntity.class, "protectedCallback");
        MockCallingBackEntity e = new MockCallingBackEntity();
        callback.performCallback(e);
        Assert.assertFalse((boolean)e.publicCallbackInvoked);
        Assert.assertTrue((boolean)e.protectedCallbackInvoked);
        Assert.assertFalse((boolean)e.privateCallbackInvoked);
        Assert.assertFalse((boolean)e.defaultCallbackInvoked);
    }

    @Test
    public void testPrivateCallbackMethod() {
        CallbackOnEntity callback = new CallbackOnEntity(MockCallingBackEntity.class, "privateCallback");
        MockCallingBackEntity e = new MockCallingBackEntity();
        callback.performCallback(e);
        Assert.assertFalse((boolean)e.publicCallbackInvoked);
        Assert.assertFalse((boolean)e.protectedCallbackInvoked);
        Assert.assertTrue((boolean)e.privateCallbackInvoked);
        Assert.assertFalse((boolean)e.defaultCallbackInvoked);
    }

    @Test
    public void testDefaultCallbackMethod() {
        CallbackOnEntity callback = new CallbackOnEntity(MockCallingBackEntity.class, "defaultCallback");
        MockCallingBackEntity e = new MockCallingBackEntity();
        callback.performCallback(e);
        Assert.assertFalse((boolean)e.publicCallbackInvoked);
        Assert.assertFalse((boolean)e.protectedCallbackInvoked);
        Assert.assertFalse((boolean)e.privateCallbackInvoked);
        Assert.assertTrue((boolean)e.defaultCallbackInvoked);
    }

    @Test
    public void testStaticCallbackMethod() {
        try {
            new CallbackOnEntity(MockCallingBackEntity.class, "staticCallback");
            Assert.fail((String)"Static methods can't be used as callbacks");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

