/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class SelectByIdTest {
    @Test
    public void testPrefetch() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        SelectById<Artist> q = SelectById.query(Artist.class, 6);
        q.prefetch(root);
        PrefetchTreeNode prefetch = q.getPrefetches();
        Assert.assertNotNull((Object)prefetch);
        Assert.assertNotNull((Object)prefetch.getNode("a.b"));
    }

    @Test
    public void testPrefetch_Path() {
        SelectById<Artist> q = SelectById.query(Artist.class, 7);
        q.prefetch("a.b", 2);
        PrefetchTreeNode prefetch = q.getPrefetches();
        Assert.assertNotNull((Object)prefetch);
        Assert.assertNotNull((Object)prefetch.getNode("a.b"));
        q.prefetch("a.c", 2);
        prefetch = q.getPrefetches();
        Assert.assertNotNull((Object)prefetch);
        Assert.assertNotNull((Object)prefetch.getNode("a.c"));
        Assert.assertNotNull((Object)prefetch.getNode("a.b"));
    }

    @Test
    public void testPrefetch_Subroot() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        SelectById<Artist> q = SelectById.query(Artist.class, 8);
        q.prefetch(root);
        PrefetchTreeNode prefetch = q.getPrefetches();
        Assert.assertNotNull((Object)prefetch.getNode("a.b"));
        PrefetchTreeNode subRoot = PrefetchTreeNode.withPath("a.b.c", 1);
        q.prefetch(subRoot);
        prefetch = q.getPrefetches();
        Assert.assertNotNull((Object)prefetch.getNode("a.b"));
        Assert.assertNotNull((Object)prefetch.getNode("a.b.c"));
    }
}

