/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class SQLTemplateTest {
    @Test
    public void testSetParams() throws Exception {
        SQLTemplate query = new SQLTemplate();
        Assert.assertTrue((boolean)query.getParams().isEmpty());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "b");
        query.setParams(params);
        Assert.assertEquals(params, query.getParams());
        query.setParams(null);
        Assert.assertTrue((boolean)query.getParams().isEmpty());
    }

    @Test
    public void testSetParamsArray() throws Exception {
        SQLTemplate query = new SQLTemplate();
        Assert.assertTrue((boolean)query.getPositionalParams().isEmpty());
        query.setParamsArray("N", "m");
        Assert.assertEquals(Arrays.asList("N", "m"), query.getPositionalParams());
        query.setParamsArray(new Object[0]);
        Assert.assertTrue((boolean)query.getPositionalParams().isEmpty());
    }

    @Test
    public void testSetParams_MixingStyles() throws Exception {
        SQLTemplate query = new SQLTemplate();
        Assert.assertTrue((boolean)query.getParams().isEmpty());
        Assert.assertTrue((boolean)query.getPositionalParams().isEmpty());
        Map<String, String> params = Collections.singletonMap("a", "b");
        query.setParams(params);
        Assert.assertEquals(params, query.getParams());
        Assert.assertTrue((boolean)query.getPositionalParams().isEmpty());
        query.setParamsArray("D", "G");
        Assert.assertEquals(Arrays.asList("D", "G"), query.getPositionalParams());
        Assert.assertTrue((boolean)query.getParams().isEmpty());
        query.setParams(null);
        Assert.assertTrue((boolean)query.getParams().isEmpty());
        Assert.assertTrue((boolean)query.getPositionalParams().isEmpty());
    }

    @Test
    public void testGetDefaultTemplate() {
        SQLTemplate query = new SQLTemplate();
        query.setDefaultTemplate("AAA # BBB");
        Assert.assertEquals((Object)"AAA # BBB", (Object)query.getDefaultTemplate());
    }

    @Test
    public void testGetTemplate() {
        SQLTemplate query = new SQLTemplate();
        Assert.assertNull((Object)query.getTemplate("key1"));
        query.setDefaultTemplate("AAA # BBB");
        Assert.assertEquals((Object)"AAA # BBB", (Object)query.getTemplate("key1"));
        query.setTemplate("key1", "XYZ");
        Assert.assertEquals((Object)"XYZ", (Object)query.getTemplate("key1"));
        query.setTemplate("key2", "123");
        Assert.assertEquals((Object)"XYZ", (Object)query.getTemplate("key1"));
        Assert.assertEquals((Object)"123", (Object)query.getTemplate("key2"));
    }

    @Test
    public void testColumnNameCapitalization() {
        SQLTemplate q1 = new SQLTemplate("E1", "SELECT");
        Assert.assertSame((Object)((Object)CapsStrategy.DEFAULT), (Object)((Object)q1.getColumnNamesCapitalization()));
        q1.setColumnNamesCapitalization(CapsStrategy.UPPER);
        Assert.assertEquals((Object)((Object)CapsStrategy.UPPER), (Object)((Object)q1.getColumnNamesCapitalization()));
    }

    @Test
    public void testSerializability() throws Exception {
        SQLTemplate o = new SQLTemplate("Test", "DO SQL");
        SQLTemplate clone = Util.cloneViaSerialization(o);
        Assert.assertTrue((boolean)(clone instanceof SQLTemplate));
        SQLTemplate c1 = clone;
        Assert.assertNotSame((Object)o, (Object)c1);
        Assert.assertEquals((Object)o.getRoot(), (Object)c1.getRoot());
        Assert.assertEquals((Object)o.getDefaultTemplate(), (Object)c1.getDefaultTemplate());
    }
}

