/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLSelectIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tPainting;
    private TableHelper tArtistCt;
    private TableHelper tPaintingInfo;

    @Before
    public void before() {
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING").setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, 3});
        this.tArtistCt = new TableHelper(this.dbHelper, "ARTIST_CT").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        this.tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO").setColumns(new String[]{"PAINTING_ID", "IMAGE_BLOB"}).setColumnTypes(new int[]{4, -4});
    }

    private void createPaintingsDataSet() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.tPainting.insert(new Object[]{i, "painting" + i, 10000.0 * (double)i});
        }
    }

    private void createArtistDataSet() throws SQLException {
        this.tArtistCt.insert(new Object[]{1, "Test", new Date(System.currentTimeMillis())});
        this.tArtistCt.insert(new Object[]{2, "Test1", new Date(System.currentTimeMillis())});
    }

    @Test
    public void test_DataRows_DataMapNameRoot() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<DataRow> q1 = SQLSelect.dataRowQuery("testmap", "SELECT * FROM PAINTING");
        Assert.assertTrue((boolean)q1.isFetchingDataRows());
        List<DataRow> result = this.context.select(q1);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
    }

    @Test
    public void test_DataRows_DefaultRoot() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<DataRow> q1 = SQLSelect.dataRowQuery("SELECT * FROM PAINTING");
        Assert.assertTrue((boolean)q1.isFetchingDataRows());
        List<DataRow> result = this.context.select(q1);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
    }

    @Test
    public void test_DataRows_ClassRoot() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Painting> q1 = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING").columnNameCaps(CapsStrategy.UPPER);
        Assert.assertFalse((boolean)q1.isFetchingDataRows());
        List<Painting> result = this.context.select(q1);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Painting));
    }

    @Test
    public void test_DataRowWithTypes() throws Exception {
        this.createArtistDataSet();
        List<DataRow> result = SQLSelect.dataRowQuery("SELECT * FROM ARTIST_CT", Integer.class, String.class, LocalDateTime.class).columnNameCaps(CapsStrategy.UPPER).select(this.context);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
        Assert.assertThat(result.get(0).get("DATE_OF_BIRTH"), (Matcher)CoreMatchers.instanceOf(LocalDateTime.class));
    }

    @Test
    public void test_DataRowWithDirectives() throws Exception {
        this.createArtistDataSet();
        List<DataRow> result = SQLSelect.dataRowQuery("SELECT #result('ARTIST_ID' 'java.lang.Double'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST_CT").select(this.context);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
        Assert.assertTrue((boolean)(result.get(0).get("ARTIST_ID") instanceof Double));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void test_DataRowWithTypesException() throws Exception {
        this.createArtistDataSet();
        SQLSelect.dataRowQuery("SELECT * FROM ARTIST_CT", Integer.class, String.class).select(this.context);
    }

    @Test
    public void testObjectArrayWithDefaultTypesReturnAndDirectives() throws Exception {
        this.createArtistDataSet();
        List<Object[]> result = SQLSelect.scalarQuery("SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST_CT").select(this.context);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertEquals((long)2L, (long)result.get(0).length);
        Assert.assertTrue((boolean)(result.get(0)[0] instanceof Long));
        Assert.assertTrue((boolean)(result.get(0)[1] instanceof String));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testObjectArrayReturnAndDirectives() throws Exception {
        this.createArtistDataSet();
        SQLSelect.scalarQuery("SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST_CT", Integer.class, String.class).select(this.context);
    }

    @Test
    public void testObjectArrayWithOneObjectDefaultTypesReturnAndDirectives() throws Exception {
        this.createArtistDataSet();
        List<Object[]> result = SQLSelect.scalarQuery("SELECT #result('ARTIST_ID' 'java.lang.Long') FROM ARTIST_CT").select(this.context);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertEquals((long)1L, (long)result.get(0).length);
        Assert.assertTrue((boolean)(result.get(0)[0] instanceof Long));
    }

    @Test
    public void test_ObjectArrayQueryWithDefaultTypes() throws Exception {
        this.createPaintingsDataSet();
        List<Object[]> result = SQLSelect.scalarQuery("SELECT PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE FROM PAINTING").select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertEquals((long)3L, (long)result.get(0).length);
    }

    @Test
    public void test_ObjectQueryWithDefaultType() throws Exception {
        this.createPaintingsDataSet();
        List<Object[]> result = SQLSelect.scalarQuery("SELECT PAINTING_ID FROM PAINTING").select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertTrue((boolean)(result.get(0)[0] instanceof Integer));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void test_ObjectArrayQueryException() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Object[]> query = SQLSelect.scalarQuery("SELECT PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE FROM PAINTING", Integer.class, String.class);
        this.context.performQuery(query);
    }

    @Test
    public void test_SingleObjectQuery() throws Exception {
        this.createPaintingsDataSet();
        List<Integer> result = SQLSelect.scalarQuery("SELECT PAINTING_ID FROM PAINTING", Integer.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Integer));
    }

    @Test
    public void testObjectArrayWithCustomType() throws SQLException {
        this.createArtistDataSet();
        List<Object[]> results = SQLSelect.scalarQuery("SELECT * FROM ARTIST_CT", Integer.class, String.class, LocalDateTime.class).select(this.context);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)(results.get(0) instanceof Object[]));
        Assert.assertEquals((long)3L, (long)results.get(0).length);
        Assert.assertTrue((boolean)(results.get(0)[2] instanceof LocalDateTime));
    }

    @Test
    public void test_DataRows_ClassRoot_Parameters() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Painting> q1 = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING WHERE PAINTING_TITLE = #bind($a)");
        q1.params("a", "painting3").columnNameCaps(CapsStrategy.UPPER);
        Assert.assertFalse((boolean)q1.isFetchingDataRows());
        Painting a = this.context.selectOne(q1);
        Assert.assertEquals((Object)"painting3", (Object)a.getPaintingTitle());
    }

    @Test
    public void test_DataRows_ClassRoot_Bind() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Painting> q1 = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING WHERE PAINTING_TITLE = #bind($a) OR PAINTING_TITLE = #bind($b)").columnNameCaps(CapsStrategy.UPPER);
        q1.params("a", "painting3").params("b", "painting4");
        List<Painting> result = this.context.select(q1);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void test_DataRows_ColumnNameCaps() throws Exception {
        SQLSelect<DataRow> q1 = SQLSelect.dataRowQuery("SELECT * FROM PAINTING WHERE PAINTING_TITLE = 'painting2'");
        q1.upperColumnNames();
        SQLTemplate r1 = (SQLTemplate)q1.getReplacementQuery(this.context.getEntityResolver());
        Assert.assertEquals((Object)((Object)CapsStrategy.UPPER), (Object)((Object)r1.getColumnNamesCapitalization()));
        q1.lowerColumnNames();
        SQLTemplate r2 = (SQLTemplate)q1.getReplacementQuery(this.context.getEntityResolver());
        Assert.assertEquals((Object)((Object)CapsStrategy.LOWER), (Object)((Object)r2.getColumnNamesCapitalization()));
    }

    @Test
    public void test_DataRows_FetchLimit() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<DataRow> q1 = SQLSelect.dataRowQuery("SELECT * FROM PAINTING");
        q1.limit(5);
        Assert.assertEquals((long)5L, (long)this.context.select(q1).size());
    }

    @Test
    public void test_DataRows_FetchOffset() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<DataRow> q1 = SQLSelect.dataRowQuery("SELECT * FROM PAINTING");
        q1.offset(4);
        Assert.assertEquals((long)16L, (long)this.context.select(q1).size());
    }

    @Test
    public void test_Append() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Painting> q1 = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING").append(" WHERE PAINTING_TITLE = #bind($a)").params("a", "painting3").columnNameCaps(CapsStrategy.UPPER);
        List<Painting> result = this.context.select(q1);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void test_Select() throws Exception {
        this.createPaintingsDataSet();
        List<Painting> result = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING WHERE PAINTING_TITLE = #bind($a)").params("a", "painting3").columnNameCaps(CapsStrategy.UPPER).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void test_SelectOne() throws Exception {
        this.createPaintingsDataSet();
        Painting a = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING WHERE PAINTING_TITLE = #bind($a)").params("a", "painting3").columnNameCaps(CapsStrategy.UPPER).selectOne(this.context);
        Assert.assertEquals((Object)"painting3", (Object)a.getPaintingTitle());
    }

    @Test
    public void test_SelectFirst() throws Exception {
        this.createPaintingsDataSet();
        Painting p = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING ORDER BY PAINTING_TITLE").columnNameCaps(CapsStrategy.UPPER).selectFirst(this.context);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"painting1", (Object)p.getPaintingTitle());
    }

    @Test
    public void test_SelectFirstByContext() throws Exception {
        this.createPaintingsDataSet();
        SQLSelect<Painting> q = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING ORDER BY PAINTING_TITLE").columnNameCaps(CapsStrategy.UPPER);
        Painting p = this.context.selectFirst(q);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"painting1", (Object)p.getPaintingTitle());
    }

    @Test
    public void test_Iterate() throws Exception {
        this.createPaintingsDataSet();
        int[] count = new int[1];
        SQLSelect.query(Painting.class, "SELECT * FROM PAINTING").columnNameCaps(CapsStrategy.UPPER).iterate(this.context, object -> {
            Assert.assertNotNull((Object)object.getPaintingTitle());
            count[0] = count[0] + 1;
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void test_Iterator() throws Exception {
        this.createPaintingsDataSet();
        try (ResultIterator<Painting> it = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING").columnNameCaps(CapsStrategy.UPPER).iterator(this.context);){
            int count = 0;
            for (Painting p : it) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
    }

    @Test
    public void test_BatchIterator() throws Exception {
        this.createPaintingsDataSet();
        try (ResultBatchIterator<Painting> it = SQLSelect.query(Painting.class, "SELECT * FROM PAINTING").columnNameCaps(CapsStrategy.UPPER).batchIterator(this.context, 5);){
            int count = 0;
            for (List<Painting> list : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)list.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void test_SelectLong() throws Exception {
        this.createPaintingsDataSet();
        long id = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING WHERE PAINTING_TITLE = #bind($a)").params("a", "painting3").selectOne(this.context).intValue();
        Assert.assertEquals((long)3L, (long)id);
    }

    @Test
    public void test_SelectLongArray() throws Exception {
        this.createPaintingsDataSet();
        List<Integer> ids = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING ORDER BY PAINTING_ID").select(this.context);
        Assert.assertEquals((long)20L, (long)ids.size());
        Assert.assertEquals((long)2L, (long)ids.get(1).intValue());
    }

    @Test
    public void test_SelectCount() throws Exception {
        this.createPaintingsDataSet();
        int c = SQLSelect.scalarQuery("SELECT COUNT(*) FROM PAINTING", Integer.class).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)c);
    }

    @Test
    public void test_ParamsArray_Single() throws Exception {
        this.createPaintingsDataSet();
        Integer id = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING WHERE PAINTING_TITLE = #bind($a)").paramsArray("painting3").selectOne(this.context);
        Assert.assertEquals((long)3L, (long)id.intValue());
    }

    @Test
    public void test_ParamsArray_Multiple() throws Exception {
        this.createPaintingsDataSet();
        List<Integer> ids = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING WHERE PAINTING_TITLE = #bind($a) OR PAINTING_TITLE = #bind($b) ORDER BY PAINTING_ID").paramsArray("painting3", "painting2").select(this.context);
        Assert.assertEquals((long)2L, (long)ids.get(0).intValue());
        Assert.assertEquals((long)3L, (long)ids.get(1).intValue());
    }

    @Test
    @Ignore(value="This is supported by Velocity only")
    public void test_ParamsArray_Multiple_OptionalChunks() throws Exception {
        this.tPainting.insert(new Object[]{1, "painting1", 1.0});
        this.tPainting.insert(new Object[]{2, "painting2", null});
        List<Integer> ids = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING #chain('OR' 'WHERE') #chunk($a) ESTIMATED_PRICE #bindEqual($a) #end #chunk($b) PAINTING_TITLE #bindEqual($b) #end #end ORDER BY PAINTING_ID").paramsArray(null, "painting1").select(this.context);
        Assert.assertEquals((long)1L, (long)ids.size());
        Assert.assertEquals((long)1L, (long)ids.get(0).longValue());
    }

    @Test
    @Ignore(value="This is supported by Velocity only")
    public void test_Params_Multiple_OptionalChunks() throws Exception {
        this.tPainting.insert(new Object[]{1, "painting1", 1.0});
        this.tPainting.insert(new Object[]{2, "painting2", null});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", null);
        params.put("b", "painting1");
        List<Integer> ids = SQLSelect.scalarQuery(Integer.class, "SELECT PAINTING_ID FROM PAINTING #chain('OR' 'WHERE') #chunk($a) ESTIMATED_PRICE #bindEqual($a) #end #chunk($b) PAINTING_TITLE #bindEqual($b) #end #end ORDER BY PAINTING_ID").params(params).select(this.context);
        Assert.assertEquals((long)1L, (long)ids.size());
        Assert.assertEquals((long)1L, (long)ids.get(0).longValue());
    }

    @Test
    public void testByteArray() throws Exception {
        byte[] data = new byte[]{1, 2, 3};
        this.tPainting.insert(new Object[]{1, "test", 0});
        this.tPaintingInfo.insert(new Object[]{1, data});
        byte[] bytes = SQLSelect.scalarQuery("SELECT IMAGE_BLOB FROM PAINTING_INFO", byte[].class).selectOne(this.context);
        Assert.assertArrayEquals((byte[])data, (byte[])bytes);
    }
}

