/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.HashMap;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.QueryResult;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLExec;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLExecIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void test_DataMapNameRoot() throws Exception {
        int inserted = SQLExec.query("testmap", "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, 'a')").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
    }

    @Test
    public void test_DefaultRoot() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, 'a')").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
    }

    @Test
    public void testReturnGeneratedKeys() {
        if (this.unitDbAdapter.supportsGeneratedKeys()) {
            QueryResult response = SQLExec.query("testmap", "INSERT INTO GENERATED_COLUMN (NAME) VALUES ('Surikov')").returnGeneratedKeys(true).execute(this.context);
            Assert.assertEquals((long)2L, (long)response.size());
            QueryResult response1 = SQLExec.query("testmap", "INSERT INTO GENERATED_COLUMN (NAME) VALUES ('Sidorov')").returnGeneratedKeys(false).execute(this.context);
            Assert.assertEquals((long)1L, (long)response1.size());
        }
    }

    @Test
    public void test_ParamsArray_Single() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, #bind($name))").paramsArray("a3").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
        Assert.assertEquals((Object)"a3", (Object)this.dbHelper.getString("ARTIST", "ARTIST_NAME").trim());
    }

    @Test
    public void test_ExecuteSelect() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, 'a')").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
        QueryResult result = SQLExec.query("SELECT * FROM ARTIST").execute(this.context);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.isList());
        Assert.assertEquals((long)1L, (long)result.firstList().size());
        DataRow row = (DataRow)result.firstList().get(0);
        if (this.unitDbAdapter.isLowerCaseNames()) {
            Assert.assertTrue((boolean)row.containsKey("artist_id"));
            Assert.assertEquals((long)1L, (long)((Number)row.get("artist_id")).longValue());
            Assert.assertEquals((Object)"a", row.get("artist_name"));
        } else {
            Assert.assertTrue((boolean)row.containsKey("ARTIST_ID"));
            Assert.assertEquals((long)1L, (long)((Number)row.get("ARTIST_ID")).longValue());
            Assert.assertEquals((Object)"a", row.get("ARTIST_NAME"));
        }
    }

    @Test
    public void test_ParamsArray_Multiple() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (#bind($id), #bind($name))").paramsArray(55, "a3").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
        Assert.assertEquals((long)55L, (long)this.dbHelper.getLong("ARTIST", "ARTIST_ID"));
        Assert.assertEquals((Object)"a3", (Object)this.dbHelper.getString("ARTIST", "ARTIST_NAME").trim());
    }

    @Test
    public void test_Execute_MultipleArrayBind() throws Exception {
        SQLExec inserter = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (#bind($id), #bind($name))");
        for (int i = 0; i < 2; ++i) {
            QueryResult result = inserter.paramsArray(i, "artist " + i).execute(this.context);
            Assert.assertEquals((long)1L, (long)result.firstUpdateCount());
        }
        Assert.assertEquals((long)2L, (long)this.dbHelper.getRowCount("ARTIST"));
    }

    @Test
    public void test_Execute_MultipleMapBind() throws Exception {
        SQLExec inserter = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (#bind($id), #bind($name))");
        for (int i = 0; i < 2; ++i) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", i);
            params.put("name", "artist " + i);
            QueryResult result = inserter.params(params).execute(this.context);
            Assert.assertEquals((long)1L, (long)result.firstUpdateCount());
        }
        Assert.assertEquals((long)2L, (long)this.dbHelper.getRowCount("ARTIST"));
    }
}

