/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ColumnSelectTest {
    @Test
    public void query() throws Exception {
        ColumnSelect q = new ColumnSelect();
        Assert.assertNull(q.getColumns());
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryWithOneColumn() throws Exception {
        ColumnSelect q = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME);
        Assert.assertEquals(Collections.singletonList(Artist.ARTIST_NAME), q.getColumns());
        Assert.assertTrue((boolean)q.singleColumn);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryWithOneColumn2() throws Exception {
        ColumnSelect q = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME);
        Assert.assertEquals(Collections.singletonList(Artist.ARTIST_NAME), q.getColumns());
        Assert.assertTrue((boolean)q.singleColumn);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryWithOneColumn3() throws Exception {
        ColumnSelect<Object[]> q = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, new Property[0]);
        Assert.assertEquals(Collections.singletonList(Artist.ARTIST_NAME), q.getColumns());
        Assert.assertFalse((boolean)q.singleColumn);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryWithMultipleColumns() throws Exception {
        ColumnSelect<Object[]> q = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        Assert.assertEquals(Arrays.asList(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH), q.getColumns());
        Assert.assertFalse((boolean)q.singleColumn);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryCount() throws Exception {
        ColumnSelect<Long> q = ObjectSelect.query(Artist.class).count();
        Assert.assertEquals(Collections.singletonList(Property.COUNT), q.getColumns());
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryCountWithProperty() throws Exception {
        ColumnSelect<Long> q = ObjectSelect.query(Artist.class).count(Artist.ARTIST_NAME);
        Assert.assertEquals(Collections.singletonList(Artist.ARTIST_NAME.count()), q.getColumns());
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void queryMinWithProperty() throws Exception {
        ColumnSelect q = ObjectSelect.query(Artist.class).min(Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE));
        Assert.assertEquals(Collections.singletonList(Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).min()), q.getColumns());
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
    }

    @Test
    public void columns() throws Exception {
        ColumnSelect<Object> q = new ColumnSelect();
        Assert.assertNull(q.getColumns());
        q.columns(Artist.ARTIST_NAME, Artist.PAINTING_ARRAY);
        Assert.assertEquals(Arrays.asList(Artist.ARTIST_NAME, Artist.PAINTING_ARRAY), q.getColumns());
        q = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        Assert.assertEquals(Arrays.asList(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH), q.getColumns());
        q.columns(Artist.PAINTING_ARRAY, new Property[0]);
        Assert.assertEquals(Arrays.asList(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY), q.getColumns());
    }

    @Test
    public void havingExpression() throws Exception {
        ColumnSelect q = new ColumnSelect();
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
        Expression expTrue = ExpressionFactory.expTrue();
        q.where(expTrue);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertEquals((Object)expTrue, (Object)q.getWhere());
        Expression expFalse = ExpressionFactory.expFalse();
        q.having(expFalse);
        Assert.assertEquals((Object)expFalse, (Object)q.getHaving());
        Assert.assertEquals((Object)expTrue, (Object)q.getWhere());
    }

    @Test
    public void havingString() throws Exception {
        ColumnSelect q = new ColumnSelect();
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
        Expression expTrue = ExpressionFactory.expTrue();
        q.where(expTrue);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertEquals((Object)expTrue, (Object)q.getWhere());
        Expression expFalse = ExpressionFactory.expFalse();
        q.having("false", new Object[0]);
        Assert.assertEquals((Object)expFalse, (Object)q.getHaving());
        Assert.assertEquals((Object)expTrue, (Object)q.getWhere());
    }

    @Test
    public void and() throws Exception {
        ColumnSelect q = new ColumnSelect();
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
        Expression expTrue = ExpressionFactory.expTrue();
        q.where(expTrue);
        q.and(expTrue);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertEquals((Object)ExpressionFactory.exp("true and true", new Object[0]), (Object)q.getWhere());
        Expression expFalse = ExpressionFactory.expFalse();
        q.having("false", new Object[0]);
        q.and(expFalse);
        Assert.assertEquals((Object)ExpressionFactory.exp("false and false", new Object[0]), (Object)q.getHaving());
        Assert.assertEquals((Object)ExpressionFactory.exp("true and true", new Object[0]), (Object)q.getWhere());
    }

    @Test
    public void or() throws Exception {
        ColumnSelect q = new ColumnSelect();
        Assert.assertNull((Object)q.getHaving());
        Assert.assertNull((Object)q.getWhere());
        Expression expTrue = ExpressionFactory.expTrue();
        q.where(expTrue);
        q.or(expTrue);
        Assert.assertNull((Object)q.getHaving());
        Assert.assertEquals((Object)ExpressionFactory.exp("true or true", new Object[0]), (Object)q.getWhere());
        Expression expFalse = ExpressionFactory.expFalse();
        q.having("false", new Object[0]);
        q.or(expFalse);
        Assert.assertEquals((Object)ExpressionFactory.exp("false or false", new Object[0]), (Object)q.getHaving());
        Assert.assertEquals((Object)ExpressionFactory.exp("true or true", new Object[0]), (Object)q.getWhere());
    }

    @Test
    public void testColumnsAddByOne() {
        ColumnSelect q = new ColumnSelect();
        Assert.assertEquals(null, q.getColumns());
        q.columns(Artist.ARTIST_NAME, new Property[0]);
        q.columns(Artist.DATE_OF_BIRTH, new Property[0]);
        q.columns(Artist.PAINTING_ARRAY, new Property[0]);
        List<Property> properties = Arrays.asList(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY);
        Assert.assertEquals(properties, q.getColumns());
    }

    @Test
    public void testColumnsAddAll() {
        ColumnSelect q = new ColumnSelect();
        Assert.assertEquals(null, q.getColumns());
        q.columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY);
        q.columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY);
        List<Property> properties = Arrays.asList(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY, Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY);
        Assert.assertEquals(properties, q.getColumns());
    }

    @Test
    public void testColumnAddByOne() {
        ColumnSelect q = new ColumnSelect();
        Assert.assertEquals(null, q.getColumns());
        q.column(Artist.ARTIST_NAME);
        q.column(Artist.DATE_OF_BIRTH);
        q.column(Artist.PAINTING_ARRAY);
        List<Property> properties = Collections.singletonList(Artist.PAINTING_ARRAY);
        Assert.assertEquals(properties, q.getColumns());
    }

    @Test
    public void testDistinct() {
        ColumnSelect q = new ColumnSelect();
        Assert.assertFalse((boolean)q.distinct);
        Assert.assertFalse((boolean)q.suppressDistinct);
        q.distinct();
        Assert.assertTrue((boolean)q.distinct);
        Assert.assertFalse((boolean)q.suppressDistinct);
        q.suppressDistinct();
        Assert.assertFalse((boolean)q.distinct);
        Assert.assertTrue((boolean)q.suppressDistinct);
    }
}

