/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.cay_2521.Issue;
import org.apache.cayenne.testdo.cay_2521.Location;
import org.apache.cayenne.testdo.cay_2521.Team;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-cay-2521.xml")
public class CAY_2521IT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tTeam;
    private TableHelper tIssue;
    private TableHelper tLocation;

    @Before
    public void before() {
        this.tTeam = new TableHelper(this.dbHelper, "TEAM1").setColumns(new String[]{"home_location_id", "id"}).setColumnTypes(new int[]{4, 4});
        this.tIssue = new TableHelper(this.dbHelper, "ISSUE").setColumns(new String[]{"home_team_id", "id", "location_id"}).setColumnTypes(new int[]{4, 4, 4});
        this.tLocation = new TableHelper(this.dbHelper, "LOCATION").setColumns(new String[]{"id", "name", "team_id"}).setColumnTypes(new int[]{4, 12, 4});
    }

    @After
    public void after() throws SQLException {
        this.tLocation.update().set("team_id", null, 4).execute();
        this.tTeam.update().set("home_location_id", null, 4).execute();
        this.tIssue.deleteAll();
        this.tLocation.deleteAll();
        this.tTeam.deleteAll();
    }

    private void createDataSet() throws SQLException {
        this.tLocation.insert(new Object[]{71, "Test", null});
        this.tTeam.insert(new Object[]{null, 8});
        this.tIssue.insert(new Object[]{8, 100, 71});
        this.tLocation.update().set("team_id", (Object)8).execute();
        this.tTeam.update().set("home_location_id", (Object)71).execute();
    }

    @Test
    public void testCay_2521() throws SQLException {
        this.createDataSet();
        List result = ObjectSelect.query(Issue.class).where(ExpressionFactory.exp("homeTeam = 8", new Object[0])).prefetch(Issue.HOME_TEAM.disjoint()).prefetch(Issue.HOME_TEAM.dot(Team.HOME_LOCATION).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertNotNull((Object)((Issue)result.get(0)).getHomeTeam().getHomeLocation());
    }

    @Test
    public void testCay_2521_ObjId() throws SQLException {
        this.createDataSet();
        Team team = Cayenne.objectForPK(this.context, Team.class, 8);
        List result = ObjectSelect.query(Issue.class).where(ExpressionFactory.exp("homeTeam = $id", team.getObjectId())).prefetch(Issue.HOME_TEAM.disjoint()).prefetch(Issue.HOME_TEAM.dot(Team.HOME_LOCATION).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertNotNull((Object)((Issue)result.get(0)).getHomeTeam().getHomeLocation());
    }

    @Test
    public void testColumnQuery() throws SQLException {
        this.createDataSet();
        List result = ObjectSelect.columnQuery(Issue.class, Issue.HOME_TEAM.dot(Team.HOME_LOCATION)).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"Test", (Object)((Location)result.get(0)).getName());
    }

    @Test
    public void testWithJoin() throws SQLException {
        this.createDataSet();
        List locations = ObjectSelect.query(Location.class).prefetch(Location.HOME_TEAM.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)locations.size());
        Assert.assertEquals((Object)"Test", (Object)((Location)locations.get(0)).getName());
        Assert.assertNotNull((Object)((Location)locations.get(0)).getHomeTeam());
    }

    @Test
    public void testWithoutJoin() throws SQLException {
        this.createDataSet();
        List teams = ObjectSelect.query(Team.class).prefetch(Team.HOME_LOCATION.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)teams.size());
        Assert.assertNotNull((Object)((Team)teams.get(0)).getHomeLocation());
    }
}

