/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.event;

import org.apache.cayenne.map.event.MapEvent;
import org.junit.Assert;
import org.junit.Test;

public class MapEventTest {
    @Test
    public void testNoNameChange() throws Exception {
        MapEventFixture event = new MapEventFixture(new Object(), "someName");
        Assert.assertEquals((Object)"someName", (Object)((MapEvent)event).getNewName());
        Assert.assertFalse((boolean)event.isNameChange());
    }

    @Test
    public void testNameChange() throws Exception {
        MapEventFixture event = new MapEventFixture(new Object(), "someName", "someOldName");
        Assert.assertEquals((Object)"someName", (Object)((MapEvent)event).getNewName());
        Assert.assertTrue((boolean)event.isNameChange());
    }

    @Test
    public void testOldName() throws Exception {
        MapEventFixture event = new MapEventFixture(new Object(), "someName");
        Assert.assertNull((Object)event.getOldName());
        event.setOldName("oldName");
        Assert.assertEquals((Object)"oldName", (Object)event.getOldName());
    }

    final class MapEventFixture
    extends MapEvent {
        String newName;

        public MapEventFixture(Object source, String newName) {
            super(source);
            this.newName = newName;
        }

        public MapEventFixture(Object source, String newName, String oldName) {
            super(source, oldName);
            this.newName = newName;
        }

        @Override
        public String getNewName() {
            return this.newName;
        }
    }
}

