/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MockMappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataMapNamespaceTest {
    protected DataMap map;

    @Before
    public void setUp() throws Exception {
        this.map = new DataMap();
    }

    @Test
    public void testNamespace() {
        Assert.assertNull((Object)this.map.getNamespace());
        MockMappingNamespace namespace = new MockMappingNamespace();
        this.map.setNamespace(namespace);
        Assert.assertSame((Object)namespace, (Object)this.map.getNamespace());
        this.map.setNamespace(null);
        Assert.assertNull((Object)this.map.getNamespace());
    }

    @Test
    public void testGetDbEntity() {
        MockMappingNamespace namespace = new MockMappingNamespace();
        this.map.setNamespace(namespace);
        DbEntity e1 = new DbEntity("entity");
        DbEntity e2 = new DbEntity("entity");
        namespace.addDbEntity(e1);
        Assert.assertSame((Object)e1, (Object)this.map.getDbEntity("entity"));
        this.map.addDbEntity(e2);
        Assert.assertSame((Object)e2, (Object)this.map.getDbEntity("entity"));
        this.map.removeDbEntity("entity", true);
        Assert.assertSame((Object)e1, (Object)this.map.getDbEntity("entity"));
    }

    @Test
    public void testGetObjEntity() throws Exception {
        MockMappingNamespace namespace = new MockMappingNamespace();
        this.map.setNamespace(namespace);
        ObjEntity e1 = new ObjEntity("entity");
        ObjEntity e2 = new ObjEntity("entity");
        namespace.addObjEntity(e1);
        Assert.assertSame((Object)e1, (Object)this.map.getObjEntity("entity"));
        this.map.addObjEntity(e2);
        Assert.assertSame((Object)e2, (Object)this.map.getObjEntity("entity"));
        this.map.removeObjEntity("entity", true);
        Assert.assertSame((Object)e1, (Object)this.map.getObjEntity("entity"));
    }

    @Test
    public void testGetProcedure() throws Exception {
        MockMappingNamespace namespace = new MockMappingNamespace();
        this.map.setNamespace(namespace);
        Procedure p1 = new Procedure("procedure");
        Procedure p2 = new Procedure("procedure");
        namespace.addProcedure(p1);
        Assert.assertSame((Object)p1, (Object)this.map.getProcedure("procedure"));
        this.map.addProcedure(p2);
        Assert.assertSame((Object)p2, (Object)this.map.getProcedure("procedure"));
        this.map.removeProcedure("procedure");
        Assert.assertSame((Object)p1, (Object)this.map.getProcedure("procedure"));
    }

    @Test
    public void testGetQuery() throws Exception {
        MockMappingNamespace namespace = new MockMappingNamespace();
        this.map.setNamespace(namespace);
        SelectQueryDescriptor q1 = QueryDescriptor.selectQueryDescriptor();
        q1.setName("query");
        SelectQueryDescriptor q2 = QueryDescriptor.selectQueryDescriptor();
        q2.setName("query");
        namespace.addQueryDescriptor(q1);
        Assert.assertSame((Object)q1, (Object)this.map.getQueryDescriptor("query"));
        this.map.addQueryDescriptor(q2);
        Assert.assertSame((Object)q2, (Object)this.map.getQueryDescriptor("query"));
        this.map.removeQueryDescriptor("query");
        Assert.assertSame((Object)q1, (Object)this.map.getQueryDescriptor("query"));
    }
}

