/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.util.Collections;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.IntegerType;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.log.CompactSlf4jJdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactSlf4jJdbcEventLoggerTest {
    private CompactSlf4jJdbcEventLogger logger;

    @Before
    public void createLogger() {
        this.logger = new CompactSlf4jJdbcEventLogger(new DefaultRuntimeProperties(Collections.emptyMap()));
    }

    @Test
    public void compactSimpleSql() {
        String processesSelectSql = this.logger.trimSqlSelectColumns("SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.F_KEY2 AS ec0_2, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?");
        Assert.assertEquals((Object)processesSelectSql, (Object)"SELECT (4 columns) FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?");
    }

    @Test
    public void compactNotSelect() {
        String processedSql = this.logger.trimSqlSelectColumns("UPDATE test SET name = 'abc', value = 123 WHERE id = 321");
        Assert.assertEquals((Object)"UPDATE test SET name = 'abc', value = 123 WHERE id = 321", (Object)processedSql);
    }

    @Test
    public void compactSubSelect() {
        String processedSql = this.logger.trimSqlSelectColumns("INSERT INTO test1 SELECT column1, column2, column3, column4, column5, column6 FROM test2 WHERE id = 321");
        Assert.assertEquals((Object)"INSERT INTO test1 SELECT (6 columns) FROM test2 WHERE id = 321", (Object)processedSql);
    }

    @Test
    public void compactUnion() {
        String processedUnionSql = this.logger.processUnionSql("SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?UNION ALL SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?union all SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.F_KEY2 AS ec0_2, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?");
        Assert.assertEquals((Object)processedUnionSql, (Object)"SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ? UNION ALL SELECT t0.NAME AS ec0_0, t0.F_KEY1 AS ec0_1, t0.PKEY AS ec0_3 FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ? UNION all SELECT (4 columns) FROM COMPOUND_FK_TEST t0 INNER JOIN COMPOUND_PK_TEST t1 ON (t0.F_KEY1 = t1.KEY1 AND t0.F_KEY2 = t1.KEY2) WHERE t1.NAME LIKE ?");
    }

    @Test
    public void compactBindings() {
        StringBuilder buffer = new StringBuilder();
        ParameterBinding[] bindings = new DbAttributeBinding[]{this.createBinding("t0.NAME", 1, "", new CharType(false, false)), this.createBinding("t0.NAME", 2, 52, new IntegerType()), this.createBinding("t0.NAME", 3, true, new BooleanType()), this.createBinding("t0.F_KEY1", 4, true, new BooleanType())};
        this.logger.appendParameters(buffer, "bind", bindings);
        Assert.assertEquals((Object)buffer.toString(), (Object)"[bind: 1->t0.NAME: {'', 52, 'true'}, 2->t0.F_KEY1: 'true']");
    }

    private DbAttributeBinding createBinding(String name, int position, Object object, ExtendedType type) {
        DbAttributeBinding dbAttributeBinding = new DbAttributeBinding(new DbAttribute(name));
        dbAttributeBinding.setValue(object);
        dbAttributeBinding.setStatementPosition(position);
        dbAttributeBinding.setExtendedType(type);
        return dbAttributeBinding;
    }
}

