/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.parser.Evaluator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class EvaluatorTest {
    @Test
    public void testEvaluator_Null() {
        Evaluator e = Evaluator.evaluator(null);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(null, null));
        Assert.assertFalse((boolean)e.eq(null, new Object()));
    }

    @Test
    public void testEvaluator_Object() {
        Object o = new Object();
        Evaluator e = Evaluator.evaluator(o);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(o, o));
        Assert.assertFalse((boolean)e.eq(o, null));
    }

    @Test
    public void testEvaluator_Number() {
        Evaluator e = Evaluator.evaluator(1);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(1, 1));
        Assert.assertFalse((boolean)e.eq(1, null));
        Assert.assertFalse((boolean)e.eq(1, 5));
        Assert.assertFalse((boolean)e.eq(1, 1.1));
    }

    @Test
    public void testEvaluator_NumberWideningEquals() {
        Evaluator e = Evaluator.evaluator(1);
        Assert.assertTrue((boolean)e.eq((byte)1, (byte)1));
        Assert.assertTrue((boolean)e.eq((byte)1, (short)1));
        Assert.assertTrue((boolean)e.eq((byte)1, 1));
        Assert.assertTrue((boolean)e.eq((byte)1, 1L));
        Assert.assertTrue((boolean)e.eq((byte)1, Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq((byte)1, 1.0));
        Assert.assertTrue((boolean)e.eq((short)1, (byte)1));
        Assert.assertTrue((boolean)e.eq((short)1, (short)1));
        Assert.assertTrue((boolean)e.eq((short)1, 1));
        Assert.assertTrue((boolean)e.eq((short)1, 1L));
        Assert.assertTrue((boolean)e.eq((short)1, Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq((short)1, 1.0));
        Assert.assertTrue((boolean)e.eq(1, (byte)1));
        Assert.assertTrue((boolean)e.eq(1, (short)1));
        Assert.assertTrue((boolean)e.eq(1, 1));
        Assert.assertTrue((boolean)e.eq(1, 1L));
        Assert.assertTrue((boolean)e.eq(1, Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq(1, 1.0));
        Assert.assertTrue((boolean)e.eq(1L, (byte)1));
        Assert.assertTrue((boolean)e.eq(1L, (short)1));
        Assert.assertTrue((boolean)e.eq(1L, 1));
        Assert.assertTrue((boolean)e.eq(1L, 1L));
        Assert.assertTrue((boolean)e.eq(1L, Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq(1L, 1.0));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), (byte)1));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), (short)1));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), 1));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), 1L));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.0f), 1.0));
        Assert.assertTrue((boolean)e.eq(1.0, (byte)1));
        Assert.assertTrue((boolean)e.eq(1.0, (short)1));
        Assert.assertTrue((boolean)e.eq(1.0, 1));
        Assert.assertTrue((boolean)e.eq(1.0, 1L));
        Assert.assertTrue((boolean)e.eq(1.0, Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)e.eq(1.0, 1.0));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.1f), Float.valueOf(1.1f)));
        Assert.assertTrue((boolean)e.eq(Float.valueOf(1.1f), 1.1));
        Assert.assertTrue((boolean)e.eq(Long.MAX_VALUE, Long.MAX_VALUE));
        Assert.assertTrue((boolean)e.eq(Double.MAX_VALUE, Double.MAX_VALUE));
        Assert.assertTrue((boolean)e.eq(1, new AtomicInteger(1)));
        Assert.assertTrue((boolean)e.eq(new AtomicInteger(1), 1));
        Assert.assertTrue((boolean)e.eq(1, new AtomicLong(1L)));
        Assert.assertTrue((boolean)e.eq(new AtomicLong(1L), 1));
        Assert.assertTrue((boolean)e.eq(1, BigInteger.ONE));
        Assert.assertTrue((boolean)e.eq(BigInteger.ONE, 1));
        BigInteger bigInt = new BigInteger(Long.valueOf(Long.MAX_VALUE).toString() + "0");
        Assert.assertTrue((boolean)e.eq(bigInt, bigInt));
    }

    @Test
    public void testEvaluator_NumberWideningCompare() {
        Evaluator e = Evaluator.evaluator(1);
        Assert.assertTrue((e.compare((byte)1, (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((byte)1, (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((byte)1, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((byte)1, 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((byte)1, Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((byte)1, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare((short)1, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1L, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.0f), 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, (byte)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, 1L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, Float.valueOf(1.0f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1.0, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.1f), Float.valueOf(1.1f)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Float.valueOf(1.1f), 1.1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Long.MAX_VALUE, Long.MAX_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(Double.MAX_VALUE, Double.MAX_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, new AtomicInteger(1)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(new AtomicInteger(1), 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, new AtomicLong(1L)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(new AtomicLong(1L), 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(1, BigInteger.ONE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compare(BigInteger.ONE, 1) == 0 ? 1 : 0) != 0);
        BigInteger bigInt = new BigInteger(Long.valueOf(Long.MAX_VALUE).toString() + "0");
        Assert.assertTrue((e.compare(bigInt, bigInt) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEvaluator_BigDecimal() {
        BigDecimal lhs = new BigDecimal("1.10");
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(lhs, new BigDecimal("1.1")));
        Assert.assertFalse((boolean)e.eq(lhs, new BigDecimal("1.10001")));
        Integer c = e.compare(lhs, new BigDecimal("1.10001"));
        Assert.assertEquals((long)-1L, (long)c.intValue());
    }

    @Test
    public void testEvaluator_Persistent() {
        ObjectId lhsId = new ObjectId("X", "k", 3);
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        ObjectId rhsId1 = new ObjectId("X", "k", 3);
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, 3));
        ObjectId rhsId2 = new ObjectId("X", "k", 4);
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, 4));
    }

    @Test
    public void testEvaluator_Persistent_StringId() {
        ObjectId lhsId = new ObjectId("X", "k", "A");
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        ObjectId rhsId1 = new ObjectId("X", "k", "A");
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, "A"));
        ObjectId rhsId2 = new ObjectId("X", "k", "B");
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, "B"));
    }

    @Test
    public void testEvaluator_Persistent_MultiKey() {
        HashMap<String, Object> lhsIdMap = new HashMap<String, Object>();
        lhsIdMap.put("a", 1);
        lhsIdMap.put("b", "B");
        ObjectId lhsId = new ObjectId("X", lhsIdMap);
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        HashMap<String, Object> rhsId1Map = new HashMap<String, Object>();
        rhsId1Map.put("a", 1);
        rhsId1Map.put("b", "B");
        ObjectId rhsId1 = new ObjectId("X", rhsId1Map);
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1Map));
        HashMap<String, Object> rhsId2Map = new HashMap<String, Object>();
        rhsId2Map.put("a", 1);
        rhsId2Map.put("b", "BX");
        ObjectId rhsId2 = new ObjectId("X", rhsId2Map);
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2Map));
        Assert.assertFalse((boolean)e.eq(lhs, "B"));
    }
}

