/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTGreaterOrEqual;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTGreaterOrEqualTest {
    @Test
    public void testEvaluate() {
        ASTGreaterOrEqual e = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertFalse((boolean)e.match(noMatch));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertTrue((boolean)e.match(match1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluate_Null() {
        ASTGreaterOrEqual gtNull = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), null);
        ASTGreaterOrEqual gtNotNull = new ASTGreaterOrEqual(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)gtNull.match(noMatch));
        Assert.assertFalse((boolean)gtNotNull.match(noMatch));
    }
}

