/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ASTDbPathIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testEvaluate_DataObject() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        this.context.commitChanges();
        Expression idExp = ExpressionFactory.exp("db:ARTIST_ID", new Object[0]);
        Assert.assertEquals((Object)Cayenne.longPKForObject(a1), (Object)idExp.evaluate(a1));
        Expression columnExp = ExpressionFactory.exp("db:ARTIST_NAME", new Object[0]);
        Assert.assertEquals((Object)"a1", (Object)columnExp.evaluate(a1));
    }

    @Test
    public void testEvaluate_DbEntity() {
        Expression e = ExpressionFactory.exp("db:paintingArray.PAINTING_TITLE", new Object[0]);
        ObjEntity ae = this.context.getEntityResolver().getObjEntity(Artist.class);
        DbEntity ade = ae.getDbEntity();
        Object objTarget = e.evaluate(ae);
        Assert.assertTrue((boolean)(objTarget instanceof DbAttribute));
        Object dbTarget = e.evaluate(ade);
        Assert.assertTrue((boolean)(dbTarget instanceof DbAttribute));
    }

    @Test
    public void testEvaluate_Related_DataObject() {
        Artist a1 = this.context.newObject(Artist.class);
        Artist a2 = this.context.newObject(Artist.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        a1.setArtistName("a1");
        a2.setArtistName("a2");
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        this.context.commitChanges();
        ASTDbPath attributeOnlyPath = new ASTDbPath("PAINTING_TITLE");
        ASTDbPath singleStepPath = new ASTDbPath("toArtist.ARTIST_NAME");
        ASTDbPath multiStepPath = new ASTDbPath("toArtist.paintingArray.PAINTING_TITLE");
        Assert.assertEquals((Object)p1.getPaintingTitle(), (Object)((Expression)attributeOnlyPath).evaluate(p1));
        Assert.assertEquals((Object)p2.getPaintingTitle(), (Object)((Expression)attributeOnlyPath).evaluate(p2));
        p1.getObjectContext().invalidateObjects(p1, p2);
        Assert.assertEquals((Object)p1.getPaintingTitle(), (Object)((Expression)attributeOnlyPath).evaluate(p1));
        Assert.assertEquals((Object)p2.getPaintingTitle(), (Object)((Expression)attributeOnlyPath).evaluate(p2));
        Assert.assertEquals((Object)a1.getArtistName(), (Object)((Expression)singleStepPath).evaluate(p1));
        Assert.assertEquals((Object)a2.getArtistName(), (Object)((Expression)singleStepPath).evaluate(p2));
        Assert.assertNull((Object)((Expression)singleStepPath).evaluate(p3));
        Assert.assertEquals((Object)p1.getPaintingTitle(), (Object)((Expression)multiStepPath).evaluate(p1));
        Assert.assertEquals((Object)p2.getPaintingTitle(), (Object)((Expression)multiStepPath).evaluate(p2));
    }
}

