/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTBetween;
import org.apache.cayenne.exp.parser.ASTNotBetween;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTBetweenTest {
    @Test
    public void testEvaluate() {
        ASTBetween between = new ASTBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        ASTNotBetween notBetween = new ASTNotBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(21));
        Assert.assertFalse((boolean)between.match(noMatch));
        Assert.assertTrue((boolean)notBetween.match(noMatch));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal(20));
        Assert.assertTrue((boolean)between.match(match1));
        Assert.assertFalse((boolean)notBetween.match(match1));
        Painting match2 = new Painting();
        match2.setEstimatedPrice(new BigDecimal(10));
        Assert.assertTrue((String)("Failed: " + between), (boolean)between.match(match2));
        Assert.assertFalse((String)("Failed: " + notBetween), (boolean)notBetween.match(match2));
        Painting match3 = new Painting();
        match3.setEstimatedPrice(new BigDecimal(11));
        Assert.assertTrue((String)("Failed: " + between), (boolean)between.match(match3));
        Assert.assertFalse((String)("Failed: " + notBetween), (boolean)notBetween.match(match3));
    }

    @Test
    public void testEvaluate_Null() {
        ASTBetween btNull = new ASTBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        ASTNotBetween btNotNull = new ASTNotBetween(new ASTObjPath("estimatedPrice"), new BigDecimal(10.0), new BigDecimal(20.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)btNull.match(noMatch));
        Assert.assertFalse((boolean)btNotNull.match(noMatch));
    }
}

