/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.sql.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TranslateExpressionIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 20; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % 5 + 1, 1});
        }
    }

    @Test
    public void testPrefetchWithTranslatedExp() {
        List result = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.PAINTING_ARRAY).dot(Painting.PAINTING_TITLE).like("painting7")).and(Painting.PAINTING_TITLE.like("painting2")).prefetch(Painting.TO_ARTIST.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"artist3", (Object)((Painting)result.get(0)).getToArtist().getArtistName());
    }

    @Test
    public void testPrefetchWithTheSamePrefetchAndQualifier() {
        List result = ObjectSelect.query(Painting.class).where(Painting.TO_GALLERY.dot(Gallery.PAINTING_ARRAY).dot(Painting.PAINTING_TITLE).eq("painting1")).and(Painting.PAINTING_TITLE.like("painting2")).prefetch(Painting.TO_GALLERY.disjoint()).prefetch(Painting.TO_GALLERY.dot(Gallery.PAINTING_ARRAY).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"painting2", (Object)((Painting)result.get(0)).getPaintingTitle());
    }

    @Test
    public void testTranslateExpression() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Painting");
        Expression expression = ExpressionFactory.pathExp("toArtist.paintingArray");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "toArtist");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("paintingArray.toArtist.paintingArray"), (Object)translatedExpression);
    }

    @Test
    public void testRelationshipPathEqualsToInput() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Painting");
        Expression expression = ExpressionFactory.pathExp("toArtist");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "toArtist");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("paintingArray.toArtist"), (Object)translatedExpression);
    }

    @Test
    public void testRelationshipNoneLeadingParts() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Painting");
        Expression expression = ExpressionFactory.pathExp("toGallery");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "toArtist");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("paintingArray.toGallery"), (Object)translatedExpression);
    }

    @Test
    public void testRelationshipSomeLeadingParts() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Painting");
        Expression expression = ExpressionFactory.pathExp("toGallery");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "toArtist.paintingArray.toGallery");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("paintingArray.toArtist.paintingArray.toGallery"), (Object)translatedExpression);
    }

    @Test
    public void testCompQualifier() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Painting");
        Expression expression = ExpressionFactory.pathExp("toArtist.artistExhibitArray.toExhibit");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "toGallery");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("paintingArray.toArtist.artistExhibitArray.toExhibit"), (Object)translatedExpression);
    }

    @Test
    public void testCompQualifierAndPref() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Artist");
        Expression expression = ExpressionFactory.pathExp("paintingArray.toGallery");
        Expression translatedExpression = entity.translateToRelatedEntity(expression, "artistExhibitArray.toExhibit");
        Assert.assertEquals((Object)ExpressionFactory.dbPathExp("artistExhibitArray.toArtist.paintingArray.toGallery"), (Object)translatedExpression);
    }
}

