/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionTest {
    @Test
    public void testToEJBQL_numericType_integer() {
        Expression e = ExpressionFactory.matchExp("consignment.parts", (Object)123);
        Assert.assertEquals((Object)"x.consignment.parts = 123", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testToEJBQL_numericType_long() {
        Expression e = ExpressionFactory.matchExp("consignment.parts", (Object)1418342400L);
        Assert.assertEquals((Object)"x.consignment.parts = 1418342400", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testToEJBQL_numericType_float() {
        Expression e = ExpressionFactory.greaterOrEqualExp("consignment.parts", (Object)Float.valueOf("3.145"));
        Assert.assertEquals((Object)"x.consignment.parts >= 3.145", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testToEJBQL_numericType_double() {
        Expression e = ExpressionFactory.greaterOrEqualExp("consignment.parts", (Object)3.14);
        Assert.assertEquals((Object)"x.consignment.parts >= 3.14", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testAppendAsEJBQL_Timestamp_ParameterCapture() throws IOException {
        Date now = new Date();
        Expression e = ExpressionFactory.greaterOrEqualExp("dateOfBirth", (Object)now);
        StringBuilder buffer = new StringBuilder();
        ArrayList<Object> parametersAccumulator = new ArrayList<Object>();
        e.appendAsEJBQL(parametersAccumulator, buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.dateOfBirth >= ?1", (Object)ejbql);
        Assert.assertEquals((long)parametersAccumulator.size(), (long)1L);
        Assert.assertEquals(parametersAccumulator.get(0), (Object)now);
    }

    @Test
    public void testAppendAsEJBQL_in_EncodeListOfParameters_ParameterCapture() throws IOException {
        Expression e = ExpressionFactory.inExp("artistName", "a", "b", "c");
        StringBuilder buffer = new StringBuilder();
        ArrayList<Object> parametersAccumulator = new ArrayList<Object>();
        e.appendAsEJBQL(parametersAccumulator, buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artistName in (?1, ?2, ?3)", (Object)ejbql);
        Assert.assertEquals((long)parametersAccumulator.size(), (long)3L);
        Assert.assertEquals(parametersAccumulator.get(0), (Object)"a");
        Assert.assertEquals(parametersAccumulator.get(1), (Object)"b");
        Assert.assertEquals(parametersAccumulator.get(2), (Object)"c");
    }

    @Test
    public void testAppendAsEJBQL_in_EncodeListOfParameters() throws IOException {
        Expression e = ExpressionFactory.inExp("artistName", "a", "b", "c");
        StringBuilder buffer = new StringBuilder();
        e.appendAsEJBQL(buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artistName in ('a', 'b', 'c')", (Object)ejbql);
    }

    @Test
    public void testAppendAsEJBQL_PersistentParamater() throws IOException {
        Artist a = new Artist();
        ObjectId aId = new ObjectId("Artist", "ARTIST_ID", 1);
        a.setObjectId(aId);
        Expression e = ExpressionFactory.matchExp("artist", (Object)a);
        StringBuilder buffer = new StringBuilder();
        e.appendAsEJBQL(buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artist = 1", (Object)ejbql);
    }

    @Test
    public void testAppendAsEJBQLNotEquals() throws IOException {
        Expression e = ExpressionFactory.exp("artistName != 'bla'", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        e.appendAsEJBQL(buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artistName <> 'bla'", (Object)ejbql);
    }

    @Test
    public void testIsNotNullEx() {
        Expression e = Artist.ARTIST_NAME.isNotNull();
        String ejbql = e.toEJBQL("x");
        Assert.assertEquals((Object)"not (x.artistName is null)", (Object)ejbql);
    }

    @Test
    public void testAndExp() {
        Expression e1 = ExpressionFactory.matchExp("name", (Object)"Picasso");
        Expression e2 = ExpressionFactory.matchExp("age", (Object)30);
        Expression exp = e1.andExp(e2);
        Assert.assertEquals((long)exp.getType(), (long)0L);
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
    }

    @Test
    public void testOrExp() {
        Expression e1 = ExpressionFactory.matchExp("name", (Object)"Picasso");
        Expression e2 = ExpressionFactory.matchExp("age", (Object)30);
        Expression exp = e1.orExp(e2);
        Assert.assertEquals((long)exp.getType(), (long)1L);
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
    }

    @Test
    public void testAndExpVarArgs() {
        Expression e1 = ExpressionFactory.matchExp("name", (Object)"Picasso");
        Expression e2 = ExpressionFactory.matchExp("age", (Object)30);
        Expression e3 = ExpressionFactory.matchExp("height", (Object)5.5);
        Expression e4 = ExpressionFactory.matchExp("numEars", (Object)1);
        Expression exp = e1.andExp(e2, e3, e4);
        Assert.assertEquals((long)exp.getType(), (long)0L);
        Assert.assertEquals((long)4L, (long)((SimpleNode)exp).jjtGetNumChildren());
    }

    @Test
    public void testOrExpVarArgs() {
        Expression e1 = ExpressionFactory.matchExp("name", (Object)"Picasso");
        Expression e2 = ExpressionFactory.matchExp("age", (Object)30);
        Expression e3 = ExpressionFactory.matchExp("height", (Object)5.5);
        Expression e4 = ExpressionFactory.matchExp("numEars", (Object)1);
        Expression exp = e1.orExp(e2, e3, e4);
        Assert.assertEquals((long)exp.getType(), (long)1L);
        Assert.assertEquals((long)4L, (long)((SimpleNode)exp).jjtGetNumChildren());
    }

    @Test
    public void testBitwiseNegate() {
        Expression exp = ExpressionFactory.exp("~7", new Object[0]);
        Assert.assertEquals((long)39L, (long)exp.getType());
        Assert.assertEquals((long)1L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)-8L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseAnd() {
        Expression exp = ExpressionFactory.exp("1 & 0", new Object[0]);
        Assert.assertEquals((long)40L, (long)exp.getType());
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)0L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseOr() {
        Expression exp = ExpressionFactory.exp("1 | 0", new Object[0]);
        Assert.assertEquals((long)41L, (long)exp.getType());
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)1L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseXor() {
        Expression exp = ExpressionFactory.exp("1 ^ 0", new Object[0]);
        Assert.assertEquals((long)42L, (long)exp.getType());
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)1L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseLeftShift() {
        Expression exp = ExpressionFactory.exp("7 << 2", new Object[0]);
        Assert.assertEquals((long)43L, (long)exp.getType());
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)28L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseRightShift() {
        Expression exp = ExpressionFactory.exp("7 >> 2", new Object[0]);
        Assert.assertEquals((long)44L, (long)exp.getType());
        Assert.assertEquals((long)2L, (long)((SimpleNode)exp).jjtGetNumChildren());
        Assert.assertEquals((Object)1L, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testBitwiseAssociativity() {
        Expression e1 = ExpressionFactory.exp("(3010 | 2012) | 4095", new Object[0]);
        Expression e2 = ExpressionFactory.exp("3010 | (2012 | 4095)", new Object[0]);
        Assert.assertEquals((Object)e1.evaluate(new Object()), (Object)e2.evaluate(new Object()));
    }

    @Test
    public void testBitwiseCommutativity() {
        Expression e1 = ExpressionFactory.exp("3010 | 4095", new Object[0]);
        Expression e2 = ExpressionFactory.exp("4095 | 3010", new Object[0]);
        Assert.assertEquals((Object)e1.evaluate(new Object()), (Object)e2.evaluate(new Object()));
    }

    @Test
    public void testBitwiseAbsorption() {
        Expression e1 = ExpressionFactory.exp("2012 | (2012 & 3010)", new Object[0]);
        Expression e2 = ExpressionFactory.exp("2012L", new Object[0]);
        Assert.assertEquals((Object)e1.evaluate(new Object()), (Object)e2.evaluate(new Object()));
    }

    @Test
    public void testBitwiseDistributivity() {
        Expression e1 = ExpressionFactory.exp("4095 | (7777 & 8888)", new Object[0]);
        Expression e2 = ExpressionFactory.exp("(4095 | 7777) & (4095 | 8888)", new Object[0]);
        Assert.assertEquals((Object)e1.evaluate(new Object()), (Object)e2.evaluate(new Object()));
    }

    @Test
    public void testBitwiseComplements() {
        Expression e1 = ExpressionFactory.exp("5555 | ~5555", new Object[0]);
        Expression e2 = ExpressionFactory.exp("9999 & ~9999", new Object[0]);
        Assert.assertEquals((Object)-1L, (Object)e1.evaluate(new Object()));
        Assert.assertEquals((Object)0L, (Object)e2.evaluate(new Object()));
    }

    @Test
    public void testBitwiseHuntingtonEquation() {
        Expression theHuntingEquation = ExpressionFactory.exp("~(~3748 | 4095) | ~(~3748 | ~4095)", new Object[0]);
        Assert.assertEquals((Object)3748L, (Object)theHuntingEquation.evaluate(new Object()));
    }

    @Test
    public void testBitwiseRobbinsEquation() {
        Expression theRobbinsEquation = ExpressionFactory.exp("~(~(5111 | 4095) | ~(5111 | ~4095))", new Object[0]);
        Assert.assertEquals((Object)5111L, (Object)theRobbinsEquation.evaluate(new Object()));
    }

    @Test
    public void testBitwisePrecedence() {
        Expression e1 = ExpressionFactory.exp("1 << 1 & 2", new Object[0]);
        Expression e2 = ExpressionFactory.exp("0 | 1 & ~(3 | ~3)", new Object[0]);
        Expression e3 = ExpressionFactory.exp("3 | ~(-3) + 2", new Object[0]);
        Expression e4 = ExpressionFactory.exp("2 * 2 | 2", new Object[0]);
        Expression e5 = ExpressionFactory.exp("6 / 2 & 3", new Object[0]);
        Assert.assertEquals((Object)2L, (Object)e1.evaluate(new Object()));
        Assert.assertEquals((Object)0L, (Object)e2.evaluate(new Object()));
        Assert.assertEquals((Object)7L, (Object)e3.evaluate(new Object()));
        Assert.assertEquals((Object)6L, (Object)e4.evaluate(new Object()));
        Assert.assertEquals((Object)3L, (Object)e5.evaluate(new Object()));
    }

    @Test
    public void testAppendAsEJBQL_NotEquals_ParameterCapture() throws IOException {
        Expression e = ExpressionFactory.exp("artistName != 'bla'", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        ArrayList<Object> parametersAccumulator = new ArrayList<Object>();
        e.appendAsEJBQL(parametersAccumulator, buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artistName <> ?1", (Object)ejbql);
        Assert.assertEquals((long)parametersAccumulator.size(), (long)1L);
        Assert.assertEquals(parametersAccumulator.get(0), (Object)"bla");
    }

    @Test
    public void testAppendAsEJBQL_Enum() throws IOException {
        Expression e = ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.THREE", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        e.appendAsEJBQL(buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.a = enum:org.apache.cayenne.exp.ExpEnum1.THREE", (Object)ejbql);
    }

    @Test
    public void testAppendAsString_StringLiteral() throws IOException {
        Expression e1 = ExpressionFactory.exp("a = 'abc'", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        e1.appendAsString(buffer);
        Assert.assertEquals((Object)"a = \"abc\"", (Object)buffer.toString());
    }

    @Test
    public void testAppendAsString_Enum() throws IOException {
        Expression e1 = ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.TWO", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        e1.appendAsString(buffer);
        Assert.assertEquals((Object)"a = enum:org.apache.cayenne.exp.ExpEnum1.TWO", (Object)buffer.toString());
    }

    @Test
    public void testCustomPruneTransform() {
        Expression exp = ExpressionFactory.exp("(false and true) and true", new Object[0]);
        Expression transformed = exp.transform(node -> {
            if (node instanceof ASTFalse) {
                return Expression.PRUNED_NODE;
            }
            return node;
        });
        Assert.assertEquals((Object)"true and true", (Object)transformed.toString());
    }
}

