/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.net.URL;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.NoopDataChannelMetaData;
import org.apache.cayenne.configuration.xml.XMLDataMapLoader;
import org.apache.cayenne.configuration.xml.XMLReaderProvider;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.resource.URLResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.XMLReader;

public class XMLDataMapLoaderTest {
    private Injector injector;
    private DataMapLoader loader;

    @Before
    public void setUp() throws Exception {
        Module testModule = binder -> {
            binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
            binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
            binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
            binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
            binder.bind(HandlerFactory.class).to(DefaultHandlerFactory.class);
            binder.bind(DataChannelMetaData.class).to(NoopDataChannelMetaData.class);
            binder.bind(XMLReader.class).toProviderInstance((Provider)new XMLReaderProvider(false)).withoutScope();
        };
        this.injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        this.loader = (DataMapLoader)this.injector.getInstance(DataMapLoader.class);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void loadMissingConfig() throws Exception {
        this.loader.load(new URLResource(new URL("file:/no_such_file_for_map_xml")));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void loadWrongVersionConfig() throws Exception {
        URL url = this.getClass().getResource("testConfigMap5.map.xml");
        this.loader.load(new URLResource(url));
    }

    @Test
    public void loadEmptyConfig() throws Exception {
        URL url = this.getClass().getResource("testConfigMap2.map.xml");
        DataMap map = this.loader.load(new URLResource(url));
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)"testConfigMap2", (Object)map.getName());
        Assert.assertTrue((boolean)map.getDbEntities().isEmpty());
        Assert.assertTrue((boolean)map.getObjEntities().isEmpty());
        Assert.assertTrue((boolean)map.getProcedures().isEmpty());
        Assert.assertTrue((boolean)map.getQueryDescriptors().isEmpty());
        Assert.assertTrue((boolean)map.getEmbeddables().isEmpty());
        Assert.assertNull((Object)map.getDefaultCatalog());
        Assert.assertNull((Object)map.getDefaultSchema());
        Assert.assertNull((Object)map.getDefaultPackage());
        Assert.assertFalse((boolean)map.isClientSupported());
    }

    @Test
    public void loadFullDataMap() {
        URL url = this.getClass().getResource("testConfigMap4.map.xml");
        DataMap map = this.loader.load(new URLResource(url));
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)"testConfigMap4", (Object)map.getName());
        Assert.assertEquals((long)12L, (long)map.getDbEntities().size());
        Assert.assertEquals((long)17L, (long)map.getObjEntities().size());
        Assert.assertEquals((long)4L, (long)map.getProcedures().size());
        Assert.assertEquals((long)14L, (long)map.getQueryDescriptors().size());
        Assert.assertEquals((long)1L, (long)map.getEmbeddables().size());
        Assert.assertEquals((Object)"TEST_CATALOG", (Object)map.getDefaultCatalog());
        Assert.assertNull((Object)map.getDefaultSchema());
        Assert.assertEquals((Object)"org.apache.cayenne.testdo.testmap", (Object)map.getDefaultPackage());
        Assert.assertTrue((boolean)map.isClientSupported());
        Assert.assertEquals((Object)"org.apache.cayenne.testdo.testmap.Artist", (Object)map.getObjEntity("Artist").getClassName());
        Assert.assertEquals((long)5L, (long)map.getObjEntity("CompoundPainting").getAttributes().size());
        Assert.assertEquals((long)3L, (long)map.getObjEntity("Artist").getRelationships().size());
        Assert.assertEquals((long)7L, (long)map.getObjEntity("ArtistCallback").getCallbackMethods().size());
        Assert.assertEquals((Object)"name = \"test\"", (Object)map.getDbEntity("ARTGROUP").getQualifier().toString());
        Assert.assertEquals((long)4L, (long)map.getDbEntity("EXHIBIT").getAttributes().size());
        Assert.assertEquals((long)3L, (long)map.getDbEntity("PAINTING").getRelationships().size());
        Assert.assertEquals((Object)"gallery_seq", (Object)map.getDbEntity("GALLERY").getPrimaryKeyGenerator().getGeneratorName());
        DbAttribute pk1 = map.getDbEntity("EXHIBIT").getAttribute("EXHIBIT_ID");
        Assert.assertFalse((boolean)pk1.isGenerated());
        Assert.assertTrue((boolean)pk1.isPrimaryKey());
        DbAttribute pk2 = map.getDbEntity("GENERATED_COLUMN").getAttribute("GENERATED_COLUMN");
        Assert.assertTrue((boolean)pk2.isGenerated());
        Assert.assertTrue((boolean)pk2.isPrimaryKey());
        Assert.assertEquals((Object)true, (Object)map.getProcedure("cayenne_tst_out_proc").isReturningValue());
        Assert.assertEquals((long)1L, (long)map.getProcedure("cayenne_tst_out_proc").getCallOutParameters().size());
        Assert.assertEquals((long)2L, (long)map.getProcedure("cayenne_tst_out_proc").getCallParameters().size());
        Assert.assertEquals((Object)"true", (Object)map.getQueryDescriptor("EjbqlQueryTest").getProperty("cayenne.GenericSelectQuery.fetchingDataRows"));
        SQLTemplateDescriptor descriptor = (SQLTemplateDescriptor)map.getQueryDescriptor("NonSelectingQuery");
        Assert.assertEquals((Object)"INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES (512, 'No Painting Like This', 12.5)", (Object)descriptor.getAdapterSql().get("org.apache.cayenne.dba.db2.DB2Adapter"));
        Assert.assertEquals((Object)"TEST", (Object)map.getEmbeddable("org.apache.cayenne.testdo.Embeddable").getAttribute("test").getDbAttributeName());
    }
}

