/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.BaseHandlerTest;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.ObjRelationshipHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.junit.Assert;
import org.junit.Test;

public class ObjRelationshipHandlerTest
extends BaseHandlerTest {
    @Test
    public void testLoad() throws Exception {
        final DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("ArtGroup");
        map.addObjEntity(entity);
        Assert.assertEquals((long)0L, (long)entity.getRelationships().size());
        this.parse("obj-relationship", new BaseHandlerTest.HandlerFactory(){

            @Override
            public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler parent) {
                return new ObjRelationshipHandler(parent, map);
            }
        });
        Assert.assertEquals((long)1L, (long)entity.getRelationships().size());
        ObjRelationship relationship = entity.getRelationship("artistArray");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)2L, (long)relationship.getDeleteRule());
        Assert.assertEquals((Object)"java.util.Map", (Object)relationship.getCollectionType());
        Assert.assertEquals((Object)"artistName", (Object)relationship.getMapKey());
        Assert.assertEquals((Object)"Artist", (Object)relationship.getTargetEntityName());
        Assert.assertTrue((boolean)relationship.isUsedForLocking());
    }
}

