/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.MockExtendedType;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedTypeMapTest {
    @Test
    public void testRegisterType() throws Exception {
        ExtendedTypeMap map = new ExtendedTypeMap();
        MockExtendedType tstType = new MockExtendedType();
        Assert.assertSame((Object)map.getDefaultType(), (Object)map.getRegisteredType(tstType.getClassName()));
        map.registerType(tstType);
        Assert.assertSame((Object)tstType, (Object)map.getRegisteredType(tstType.getClassName()));
        map.unregisterType(tstType.getClassName());
        Assert.assertSame((Object)map.getDefaultType(), (Object)map.getRegisteredType(tstType.getClassName()));
    }

    @Test
    public void testRegisterTypeSubclasses() throws Exception {
        ExtendedTypeMap map = new ExtendedTypeMap();
        MockExtendedType tstType1 = new MockExtendedType(List.class);
        MockExtendedType tstType2 = new MockExtendedType(ArrayList.class);
        map.registerType(tstType1);
        Assert.assertSame((Object)tstType1, (Object)map.getRegisteredType(List.class));
        Assert.assertNotSame((Object)tstType1, (Object)map.getRegisteredType(ArrayList.class));
        map = new ExtendedTypeMap();
        map.registerType(tstType2);
        Assert.assertNotSame((Object)tstType2, (Object)map.getRegisteredType(List.class));
        Assert.assertSame((Object)tstType2, (Object)map.getRegisteredType(ArrayList.class));
        map = new ExtendedTypeMap();
        map.registerType(tstType1);
        map.registerType(tstType2);
        Assert.assertSame((Object)tstType1, (Object)map.getRegisteredType(List.class));
        Assert.assertSame((Object)tstType2, (Object)map.getRegisteredType(ArrayList.class));
        map = new ExtendedTypeMap();
        map.registerType(tstType2);
        map.registerType(tstType1);
        Assert.assertSame((Object)tstType2, (Object)map.getRegisteredType(ArrayList.class));
        Assert.assertSame((Object)tstType1, (Object)map.getRegisteredType(List.class));
    }

    @Test
    public void testRegisterArrayType() throws Exception {
        ExtendedTypeMap map = new ExtendedTypeMap();
        ByteArrayType tstType = new ByteArrayType(false, true);
        map.registerType(tstType);
        Assert.assertSame((Object)tstType, (Object)map.getRegisteredType(tstType.getClassName()));
        Assert.assertSame((Object)tstType, (Object)map.getRegisteredType(byte[].class));
        map.unregisterType(tstType.getClassName());
        Assert.assertTrue((map.getRegisteredType(tstType.getClassName()).getClass().getName().indexOf("SerializableTypeFactory") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegisteredTypeName() throws Exception {
        ExtendedTypeMap map = new ExtendedTypeMap();
        MockExtendedType tstType = new MockExtendedType();
        Assert.assertNotNull((Object)map.getRegisteredTypeNames());
        Assert.assertEquals((long)0L, (long)map.getRegisteredTypeNames().length);
        map.registerType(tstType);
        Assert.assertNotNull((Object)map.getRegisteredTypeNames());
        Assert.assertEquals((long)1L, (long)map.getRegisteredTypeNames().length);
        Assert.assertEquals((Object)tstType.getClassName(), (Object)map.getRegisteredTypeNames()[0]);
    }
}

