/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.unsupported_distinct_types.Customer;
import org.apache.cayenne.testdo.unsupported_distinct_types.Product;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-unsupported-distinct-types.xml")
public class SelectActionWithUnsupportedDistinctTypesIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    private TableHelper tProduct;
    private TableHelper tComposition;
    private TableHelper tCustomer;
    private TableHelper tOrders;

    @Before
    public void setUp() throws Exception {
        this.tProduct = new TableHelper(this.dbHelper, "PRODUCT");
        this.tProduct.setColumns(new String[]{"ID", "LONGVARCHAR_COL"});
        this.tCustomer = new TableHelper(this.dbHelper, "CUSTOMER");
        this.tCustomer.setColumns(new String[]{"ID", "LONGVARCHAR_COL"});
        this.tComposition = new TableHelper(this.dbHelper, "COMPOSITION");
        this.tComposition.setColumns(new String[]{"BASE_ID", "CONTAINED_ID"});
        this.tOrders = new TableHelper(this.dbHelper, "ORDERS");
        this.tOrders.setColumns(new String[]{"CUSTOMER_ID", "PRODUCT_ID"});
    }

    private void createCompositionManyToManyDataSet() throws SQLException {
        this.tProduct.insert(new Object[]{1, "product1"});
        this.tProduct.insert(new Object[]{2, "product2"});
        this.tProduct.insert(new Object[]{3, "product3"});
        this.tProduct.insert(new Object[]{4, "product4"});
        this.tComposition.insert(new Object[]{2, 1});
        this.tComposition.insert(new Object[]{3, 1});
        this.tComposition.insert(new Object[]{3, 2});
        this.tComposition.insert(new Object[]{4, 1});
        this.tComposition.insert(new Object[]{4, 2});
        this.tComposition.insert(new Object[]{4, 3});
    }

    private void createOrdersManyToManyDataSet() throws SQLException {
        this.tProduct.insert(new Object[]{1, "product1"});
        this.tProduct.insert(new Object[]{2, "product2"});
        this.tProduct.insert(new Object[]{3, "product3"});
        this.tCustomer.insert(new Object[]{1, "customer1"});
        this.tCustomer.insert(new Object[]{2, "customer2"});
        this.tCustomer.insert(new Object[]{3, "customer3"});
        this.tOrders.insert(new Object[]{1, 1});
        this.tOrders.insert(new Object[]{2, 1});
        this.tOrders.insert(new Object[]{2, 2});
        this.tOrders.insert(new Object[]{3, 1});
        this.tOrders.insert(new Object[]{3, 2});
        this.tOrders.insert(new Object[]{3, 3});
    }

    @Test
    public void testCompositionSelectManyToManyQuery() throws SQLException {
        this.createCompositionManyToManyDataSet();
        SelectQuery<Product> query = new SelectQuery<Product>(Product.class);
        query.addPrefetch("contained");
        query.addPrefetch("base");
        List result = this.context.performQuery(query);
        Assert.assertNotNull((Object)result);
        for (Product product : result) {
            List<Product> productsContained = product.getContained();
            Assert.assertNotNull(productsContained);
            List<Product> productsBase = product.getBase();
            Assert.assertNotNull(productsBase);
            Assert.assertEquals((long)3L, (long)(productsContained.size() + productsBase.size()));
        }
    }

    @Test
    public void testOrdersSelectManyToManyQuery() throws SQLException {
        this.createOrdersManyToManyDataSet();
        ArrayList<Integer> assertSizes = new ArrayList<Integer>(3);
        assertSizes.addAll(Arrays.asList(1, 2, 3));
        SelectQuery<Product> productQuery = new SelectQuery<Product>(Product.class);
        productQuery.addPrefetch("orderBy");
        List productResult = this.context.performQuery(productQuery);
        Assert.assertNotNull((Object)productResult);
        ArrayList<Integer> orderBySizes = new ArrayList<Integer>(3);
        for (Product product : productResult) {
            List<Customer> orderBy = product.getOrderBy();
            Assert.assertNotNull(orderBy);
            orderBySizes.add(orderBy.size());
        }
        Assert.assertTrue((boolean)assertSizes.containsAll(orderBySizes));
        SelectQuery<Customer> customerQuery = new SelectQuery<Customer>(Customer.class);
        customerQuery.addPrefetch("order");
        List customerResult = this.context.performQuery(customerQuery);
        Assert.assertNotNull((Object)customerResult);
        ArrayList<Integer> orderSizes = new ArrayList<Integer>(3);
        for (Customer customer : customerResult) {
            List<Product> orders = customer.getOrder();
            Assert.assertNotNull(orders);
            orderSizes.add(orders.size());
        }
        Assert.assertTrue((boolean)assertSizes.containsAll(orderSizes));
    }
}

