/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ToManyList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.PersistentObjectList;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ToManyListIT
extends ServerCase {
    @Inject
    private DataContext context;

    private ToManyList createForNewArtist() {
        Artist artist = this.context.newObject(Artist.class);
        return new ToManyList(artist, Artist.PAINTING_ARRAY.getName());
    }

    private ToManyList createForExistingArtist() {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("aa");
        this.context.commitChanges();
        return new ToManyList(artist, Artist.PAINTING_ARRAY.getName());
    }

    @Test
    public void testNewAddRemove() throws Exception {
        ToManyList list = this.createForNewArtist();
        Assert.assertFalse((String)"Expected resolved list when created with a new object", (boolean)list.isFault());
        Assert.assertEquals((long)0L, (long)list.size());
        Painting p1 = this.context.newObject(Painting.class);
        list.add(p1);
        Assert.assertEquals((long)1L, (long)list.size());
        Painting p2 = this.context.newObject(Painting.class);
        list.add(p2);
        Assert.assertEquals((long)2L, (long)list.size());
        list.remove(p1);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSavedUnresolvedAddRemove() throws Exception {
        ToManyList list = this.createForExistingArtist();
        list.getRelationshipOwner().setPersistenceState(4);
        Assert.assertTrue((String)"List must be unresolved for an existing object", (boolean)list.isFault());
        Painting p1 = this.context.newObject(Painting.class);
        list.add(p1);
        Assert.assertTrue((String)"List must be unresolved when adding an object...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p1));
        Painting p2 = this.context.newObject(Painting.class);
        list.add(p2);
        Assert.assertTrue((String)"List must be unresolved when adding an object...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p2));
        list.remove(p1);
        Assert.assertTrue((String)"List must be unresolved when removing an object...", (boolean)list.isFault());
        Assert.assertFalse((boolean)this.addedToUnresolved(list).contains(p1));
        int size = list.size();
        Assert.assertFalse((String)"List must be resolved after checking a size...", (boolean)list.isFault());
        Assert.assertEquals((long)1L, (long)size);
        Assert.assertTrue((boolean)this.getValue(list).contains(p2));
    }

    @Test
    public void testSavedUnresolvedMerge() throws Exception {
        ToManyList list = this.createForExistingArtist();
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        ((Artist)list.getRelationshipOwner()).addToPaintingArray(p1);
        this.context.commitChanges();
        list.getRelationshipOwner().setPersistenceState(4);
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        list.add(p1);
        Assert.assertTrue((String)"List must be unresolved when adding an object...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p1));
        Painting p2 = this.context.newObject(Painting.class);
        list.add(p2);
        Assert.assertTrue((String)"List must be unresolved when adding an object...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p2));
        int size = list.size();
        Assert.assertFalse((String)"List must be resolved after checking a size...", (boolean)list.isFault());
        Assert.assertEquals((long)2L, (long)size);
        Assert.assertTrue((boolean)this.getValue(list).contains(p2));
        Assert.assertTrue((boolean)this.getValue(list).contains(p1));
    }

    @Test
    public void testThrowOutDeleted() throws Exception {
        ToManyList list = this.createForExistingArtist();
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        ((Artist)list.getRelationshipOwner()).addToPaintingArray(p1);
        ((Artist)list.getRelationshipOwner()).addToPaintingArray(p2);
        this.context.commitChanges();
        list.getRelationshipOwner().setPersistenceState(4);
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        list.add(p1);
        list.add(p2);
        Assert.assertTrue((String)"List must be unresolved when adding an object...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p2));
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p1));
        ((Artist)list.getRelationshipOwner()).removeFromPaintingArray(p2);
        this.context.deleteObjects(p2);
        this.context.commitChanges();
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        Assert.assertTrue((String)"List must be unresolved when an object was deleted externally...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p2));
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p1));
        int size = list.size();
        Assert.assertFalse((String)"List must be resolved after checking a size...", (boolean)list.isFault());
        Assert.assertEquals((String)"Deleted object must have been purged...", (long)1L, (long)size);
        Assert.assertTrue((boolean)this.getValue(list).contains(p1));
        Assert.assertFalse((String)"Deleted object must have been purged...", (boolean)this.getValue(list).contains(p2));
    }

    @Test
    public void testRealRelationship() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("aaa");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        this.context.commitChanges();
        this.context.invalidateObjects(artist);
        ToManyList list = (ToManyList)artist.getPaintingArray();
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        artist.addToPaintingArray(p1);
        artist.addToPaintingArray(p2);
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        this.context.commitChanges();
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        int size = list.size();
        Assert.assertFalse((String)"List must be resolved...", (boolean)list.isFault());
        Assert.assertTrue((boolean)list.contains(p1));
        Assert.assertTrue((boolean)list.contains(p2));
        Assert.assertEquals((long)2L, (long)size);
    }

    @Test
    public void testRealRelationshipRollback() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("aaa");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        artist.addToPaintingArray(p1);
        this.context.commitChanges();
        this.context.invalidateObjects(artist);
        ToManyList list = (ToManyList)artist.getPaintingArray();
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        Painting p2 = this.context.newObject(Painting.class);
        artist.addToPaintingArray(p2);
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        Assert.assertTrue((boolean)this.addedToUnresolved(list).contains(p2));
        this.context.rollbackChanges();
        Assert.assertTrue((String)"List must be unresolved...", (boolean)list.isFault());
        Assert.assertTrue((boolean)list.contains(p1));
        Assert.assertFalse((boolean)list.contains(p2));
        Assert.assertFalse((String)"List must be resolved...", (boolean)list.isFault());
    }

    private List<?> getValue(ToManyList list) {
        return list.getValueDirectly();
    }

    private LinkedList<?> addedToUnresolved(ToManyList list) throws Exception {
        Field f = PersistentObjectList.class.getDeclaredField("addedToUnresolved");
        f.setAccessible(true);
        return (LinkedList)f.get(list);
    }
}

