/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextWriteIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext context;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, -5, 3});
        TableHelper tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW", "IMAGE_BLOB"});
    }

    private void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
    }

    private void createMixedDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 3000});
        this.tPainting.insert(new Object[]{33002, "P_artist2", 33002, 3000});
        this.tPainting.insert(new Object[]{33003, "P_artist3", 33003, 3000});
        this.tPainting.insert(new Object[]{33004, "P_artist4", 33004, 3000});
        this.tPainting.insert(new Object[]{33005, "P_artist5", null, 3000});
        this.tPainting.insert(new Object[]{33006, "P_artist6", 33001, 3000});
    }

    private void createNullifyToOneDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 3000});
    }

    private void createSingleArtistDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
    }

    private DataContext createDataContext() {
        this.context.getObjectStore().objectMap = new HashMap<Object, Persistent>();
        return this.context;
    }

    @Test
    public void testDeleteNew() throws Exception {
        this.createSingleArtistDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        Artist a = Cayenne.objectForPK(childContext, Artist.class, 33001);
        Painting p = childContext.newObject(Painting.class);
        p.setPaintingTitle("X");
        a.addToPaintingArray(p);
        childContext.commitChangesToParent();
        childContext.deleteObjects(p);
        a.removeFromPaintingArray(p);
        childContext.commitChangesToParent();
    }

    @Test
    public void testNullifyToOne() throws Exception {
        this.createNullifyToOneDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        ObjectContext childContextPeer = this.runtime.newContext(context);
        Painting childP1 = Cayenne.objectForPK(childContext, Painting.class, 33001);
        Cayenne.objectForPK(childContextPeer, Painting.class, 33001);
        childP1.setToArtist(null);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childP1.getPersistenceState());
            Painting parentP1 = (Painting)context.getGraphManager().getNode(childP1.getObjectId());
            Assert.assertNotNull((Object)parentP1);
            Assert.assertEquals((long)4L, (long)parentP1.getPersistenceState());
            Assert.assertNull((Object)parentP1.getToArtist());
        });
    }

    @Test
    public void testCommitChangesToParent() throws Exception {
        this.createArtistsDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(Artist.ARTIST_NAME.asc());
        List objects = childContext.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Artist childNew = childContext.newObject(Artist.class);
        childNew.setArtistName("NNN");
        Artist childModified = (Artist)objects.get(0);
        childModified.setArtistName("MMM");
        Artist childCommitted = (Artist)objects.get(1);
        Artist childHollow = (Artist)objects.get(3);
        childContext.invalidateObjects(childHollow);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childNew.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childModified.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childCommitted.getPersistenceState());
            Assert.assertEquals((long)5L, (long)childHollow.getPersistenceState());
            Artist parentNew = (Artist)context.getGraphManager().getNode(childNew.getObjectId());
            Artist parentModified = (Artist)context.getGraphManager().getNode(childModified.getObjectId());
            Artist parentCommitted = (Artist)context.getGraphManager().getNode(childCommitted.getObjectId());
            Artist parentHollow = (Artist)context.getGraphManager().getNode(childHollow.getObjectId());
            Assert.assertNotNull((Object)parentNew);
            Assert.assertEquals((long)2L, (long)parentNew.getPersistenceState());
            Assert.assertEquals((Object)"NNN", (Object)parentNew.getArtistName());
            Assert.assertNotNull((Object)parentModified);
            Assert.assertEquals((long)4L, (long)parentModified.getPersistenceState());
            Assert.assertEquals((Object)"MMM", (Object)parentModified.getArtistName());
            Assert.assertNotNull((Object)context.getObjectStore().getChangesByObjectId().get(parentModified.getObjectId()));
            Assert.assertNotNull((Object)parentCommitted);
            Assert.assertEquals((long)3L, (long)parentCommitted.getPersistenceState());
            Assert.assertNotNull((Object)parentHollow);
        });
    }

    @Test
    public void testCommitChangesToParentDeleted() throws Exception {
        this.createArtistsDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(Artist.ARTIST_NAME.asc());
        List objects = childContext.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Artist childDeleted = (Artist)objects.get(2);
        childContext.deleteObjects(childDeleted);
        childDeleted.setArtistName("DDD");
        childContext.commitChangesToParent();
        Assert.assertEquals((long)1L, (long)childDeleted.getPersistenceState());
        Artist parentDeleted = (Artist)context.getGraphManager().getNode(childDeleted.getObjectId());
        Assert.assertNotNull((Object)parentDeleted);
        Assert.assertEquals((long)6L, (long)parentDeleted.getPersistenceState());
        Assert.assertEquals((Object)"DDD", (Object)parentDeleted.getArtistName());
    }

    @Test
    public void testCommitChanges() throws Exception {
        this.createArtistsDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(Artist.ARTIST_NAME.asc());
        List objects = childContext.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Artist childNew = childContext.newObject(Artist.class);
        childNew.setArtistName("NNN");
        Artist childModified = (Artist)objects.get(0);
        childModified.setArtistName("MMM");
        Artist childCommitted = (Artist)objects.get(1);
        Artist childDeleted = (Artist)objects.get(2);
        childContext.deleteObjects(childDeleted);
        childDeleted.setArtistName("DDD");
        Artist childHollow = (Artist)objects.get(3);
        childContext.invalidateObjects(childHollow);
        childContext.commitChanges();
        Assert.assertEquals((long)3L, (long)childNew.getPersistenceState());
        Assert.assertEquals((long)3L, (long)childModified.getPersistenceState());
        Assert.assertEquals((long)3L, (long)childCommitted.getPersistenceState());
        Assert.assertEquals((long)1L, (long)childDeleted.getPersistenceState());
        Assert.assertEquals((long)5L, (long)childHollow.getPersistenceState());
        Artist parentNew = (Artist)context.getGraphManager().getNode(childNew.getObjectId());
        Artist parentModified = (Artist)context.getGraphManager().getNode(childModified.getObjectId());
        Artist parentCommitted = (Artist)context.getGraphManager().getNode(childCommitted.getObjectId());
        Artist parentDeleted = (Artist)context.getGraphManager().getNode(childDeleted.getObjectId());
        Artist parentHollow = (Artist)context.getGraphManager().getNode(childHollow.getObjectId());
        Assert.assertNotNull((Object)parentNew);
        Assert.assertEquals((long)3L, (long)parentNew.getPersistenceState());
        Assert.assertEquals((Object)"NNN", (Object)parentNew.getArtistName());
        Assert.assertNotNull((Object)parentModified);
        Assert.assertEquals((long)3L, (long)parentModified.getPersistenceState());
        Assert.assertEquals((Object)"MMM", (Object)parentModified.getArtistName());
        Assert.assertNull((Object)context.getObjectStore().getChangesByObjectId().get(parentModified.getObjectId()));
        Assert.assertNull((String)"Deleted object should not be registered.", (Object)parentDeleted);
        Assert.assertNotNull((Object)parentCommitted);
        Assert.assertEquals((long)3L, (long)parentCommitted.getPersistenceState());
        Assert.assertNotNull((Object)parentHollow);
    }

    @Test
    public void testCommitChangesToParent_MergeProperties() throws Exception {
        this.createMixedDataSet();
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.addOrdering(Painting.PAINTING_TITLE.asc());
        List objects = childContext.performQuery(query);
        Assert.assertEquals((long)6L, (long)objects.size());
        Painting childModifiedSimple = (Painting)objects.get(0);
        childModifiedSimple.setPaintingTitle("C_PT");
        Painting childModifiedToOne = (Painting)objects.get(1);
        childModifiedToOne.setToArtist(childModifiedSimple.getToArtist());
        Artist childModifiedToMany = ((Painting)objects.get(2)).getToArtist();
        childModifiedToMany.getPaintingArray().size();
        childModifiedToMany.addToPaintingArray((Painting)objects.get(3));
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childModifiedSimple.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childModifiedToOne.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childModifiedToMany.getPersistenceState());
            Painting parentModifiedSimple = (Painting)context.getGraphManager().getNode(childModifiedSimple.getObjectId());
            Painting parentModifiedToOne = (Painting)context.getGraphManager().getNode(childModifiedToOne.getObjectId());
            Artist parentModifiedToMany = (Artist)context.getGraphManager().getNode(childModifiedToMany.getObjectId());
            Assert.assertNotNull((Object)parentModifiedSimple);
            Assert.assertEquals((long)4L, (long)parentModifiedSimple.getPersistenceState());
            Assert.assertEquals((Object)"C_PT", (Object)parentModifiedSimple.getPaintingTitle());
            Assert.assertNotNull((Object)context.getObjectStore().getChangesByObjectId().get(parentModifiedSimple.getObjectId()));
            Assert.assertNotNull((Object)parentModifiedToOne);
            Assert.assertEquals((long)4L, (long)parentModifiedToOne.getPersistenceState());
            Assert.assertNotNull((Object)parentModifiedToOne.getToArtist());
            Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject(parentModifiedToOne.getToArtist()));
            Assert.assertNotNull((Object)context.getObjectStore().getChangesByObjectId().get(parentModifiedToOne.getObjectId()));
            Assert.assertNotNull((Object)parentModifiedToMany);
            Assert.assertEquals((long)4L, (long)parentModifiedToMany.getPersistenceState());
            List<Painting> paintings = parentModifiedToMany.getPaintingArray();
            Assert.assertEquals((long)2L, (long)paintings.size());
        });
    }

    @Test
    public void testCommitChangesToParentPropagatedKey() {
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        Painting childMaster = childContext.newObject(Painting.class);
        childMaster.setPaintingTitle("Master");
        PaintingInfo childDetail1 = childContext.newObject(PaintingInfo.class);
        childDetail1.setTextReview("Detail1");
        childDetail1.setPainting(childMaster);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childMaster.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childDetail1.getPersistenceState());
            Painting parentMaster = (Painting)context.getGraphManager().getNode(childMaster.getObjectId());
            Assert.assertNotNull((Object)parentMaster);
            Assert.assertEquals((long)2L, (long)parentMaster.getPersistenceState());
            PaintingInfo parentDetail1 = (PaintingInfo)context.getGraphManager().getNode(childDetail1.getObjectId());
            Assert.assertNotNull((Object)parentDetail1);
            Assert.assertEquals((long)2L, (long)parentDetail1.getPersistenceState());
            Assert.assertSame((Object)parentMaster, (Object)parentDetail1.getPainting());
            Assert.assertSame((Object)parentDetail1, (Object)parentMaster.getToPaintingInfo());
        });
    }

    @Test
    public void testCommitChangesToParentFlattened() {
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        Artist childO1 = childContext.newObject(Artist.class);
        childO1.setArtistName("Master");
        ArtGroup childO2 = childContext.newObject(ArtGroup.class);
        childO2.setName("Detail1");
        childO2.addToArtistArray(childO1);
        ObjEntity ent = childContext.getEntityResolver().getObjEntity("ArtGroup");
        Collection<ObjRelationship> rels = ent.getDeclaredRelationships();
        Assert.assertEquals((long)3L, (long)rels.size());
        Assert.assertEquals((long)1L, (long)childO1.getGroupArray().size());
        Assert.assertEquals((long)1L, (long)childO2.getArtistArray().size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childO1.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childO2.getPersistenceState());
            Artist parentO1 = (Artist)context.getGraphManager().getNode(childO1.getObjectId());
            Assert.assertNotNull((Object)parentO1);
            Assert.assertEquals((long)2L, (long)parentO1.getPersistenceState());
            ArtGroup parentO2 = (ArtGroup)context.getGraphManager().getNode(childO2.getObjectId());
            Assert.assertNotNull((Object)parentO2);
            Assert.assertEquals((long)2L, (long)parentO2.getPersistenceState());
            Assert.assertEquals((long)1L, (long)parentO1.getGroupArray().size());
            Assert.assertEquals((long)1L, (long)parentO2.getArtistArray().size());
            Assert.assertTrue((boolean)parentO2.getArtistArray().contains(parentO1));
            Assert.assertTrue((boolean)parentO1.getGroupArray().contains(parentO2));
        });
    }

    @Test
    public void testCommitChangesToParentFlattenedMultipleFlush() {
        DataContext context = this.createDataContext();
        ObjectContext childContext = this.runtime.newContext(context);
        Artist childO1 = childContext.newObject(Artist.class);
        childO1.setArtistName("o1");
        ArtGroup childO2 = childContext.newObject(ArtGroup.class);
        childO2.setName("o2");
        childO2.addToArtistArray(childO1);
        childContext.commitChangesToParent();
        ArtGroup childO3 = childContext.newObject(ArtGroup.class);
        childO3.setName("o3");
        childO1.addToGroupArray(childO3);
        Assert.assertEquals((long)2L, (long)childO1.getGroupArray().size());
        Assert.assertEquals((long)1L, (long)childO2.getArtistArray().size());
        Assert.assertEquals((long)1L, (long)childO3.getArtistArray().size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childO1.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childO2.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childO3.getPersistenceState());
            Artist parentO1 = (Artist)context.getGraphManager().getNode(childO1.getObjectId());
            Assert.assertNotNull((Object)parentO1);
            Assert.assertEquals((long)2L, (long)parentO1.getPersistenceState());
            ArtGroup parentO2 = (ArtGroup)context.getGraphManager().getNode(childO2.getObjectId());
            Assert.assertNotNull((Object)parentO2);
            Assert.assertEquals((long)2L, (long)parentO2.getPersistenceState());
            ArtGroup parentO3 = (ArtGroup)context.getGraphManager().getNode(childO3.getObjectId());
            Assert.assertNotNull((Object)parentO3);
            Assert.assertEquals((long)2L, (long)parentO3.getPersistenceState());
            Assert.assertEquals((long)2L, (long)parentO1.getGroupArray().size());
            Assert.assertEquals((long)1L, (long)parentO2.getArtistArray().size());
            Assert.assertEquals((long)1L, (long)parentO3.getArtistArray().size());
            Assert.assertTrue((boolean)parentO2.getArtistArray().contains(parentO1));
            Assert.assertTrue((boolean)parentO3.getArtistArray().contains(parentO1));
            Assert.assertTrue((boolean)parentO1.getGroupArray().contains(parentO2));
            Assert.assertTrue((boolean)parentO1.getGroupArray().contains(parentO3));
        });
        childO1.removeFromGroupArray(childO2);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            childContext.commitChangesToParent();
            Assert.assertEquals((long)3L, (long)childO1.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childO2.getPersistenceState());
            Assert.assertEquals((long)3L, (long)childO3.getPersistenceState());
            Artist parentO1 = (Artist)context.getGraphManager().getNode(childO1.getObjectId());
            Assert.assertNotNull((Object)parentO1);
            Assert.assertEquals((long)2L, (long)parentO1.getPersistenceState());
            ArtGroup parentO2 = (ArtGroup)context.getGraphManager().getNode(childO2.getObjectId());
            Assert.assertNotNull((Object)parentO2);
            Assert.assertEquals((long)2L, (long)parentO2.getPersistenceState());
            ArtGroup parentO3 = (ArtGroup)context.getGraphManager().getNode(childO3.getObjectId());
            Assert.assertNotNull((Object)parentO3);
            Assert.assertEquals((long)2L, (long)parentO3.getPersistenceState());
            Assert.assertEquals((long)1L, (long)parentO1.getGroupArray().size());
            Assert.assertEquals((long)0L, (long)parentO2.getArtistArray().size());
            Assert.assertEquals((long)1L, (long)parentO3.getArtistArray().size());
            Assert.assertTrue((boolean)parentO3.getArtistArray().contains(parentO1));
            Assert.assertTrue((boolean)parentO1.getGroupArray().contains(parentO3));
        });
    }

    @Test
    public void testAddRemove() {
        DataContext context = this.createDataContext();
        ObjectContext child = this.runtime.newContext(context);
        Artist a = child.newObject(Artist.class);
        a.setArtistName("X");
        child.commitChanges();
        Painting p1 = child.newObject(Painting.class);
        p1.setPaintingTitle("P1");
        a.addToPaintingArray(p1);
        Painting p2 = child.newObject(Painting.class);
        p2.setPaintingTitle("P2");
        a.addToPaintingArray(p2);
        a.removeFromPaintingArray(p2);
        child.deleteObjects(p2);
        child.commitChangesToParent();
    }

    @Test
    public void testCAY1194() {
        DataContext context = this.createDataContext();
        Artist artist = context.newObject(Artist.class);
        artist.setArtistName("111");
        ObjectContext child = this.runtime.newContext(context);
        Painting painting = child.newObject(Painting.class);
        painting.setPaintingTitle("222");
        Artist localParentMt = child.localObject(artist);
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
        Assert.assertEquals((long)0L, (long)localParentMt.getPaintingArray().size());
        painting.setToArtist(localParentMt);
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
        Assert.assertEquals((long)1L, (long)localParentMt.getPaintingArray().size());
        Assert.assertEquals((Object)localParentMt.getPaintingArray().get(0).getObjectContext(), (Object)child);
        child.commitChangesToParent();
        Assert.assertEquals((long)1L, (long)artist.getPaintingArray().size());
        Assert.assertEquals((Object)artist.getPaintingArray().get(0).getObjectContext(), (Object)context);
    }
}

