/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.enum_test.Enum1;
import org.apache.cayenne.testdo.enum_test.EnumEntity;
import org.apache.cayenne.testdo.enum_test.EnumEntity2;
import org.apache.cayenne.testdo.enum_test.EnumEntity3;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-enum.xml")
public class EnumIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;

    private void createDataSet() throws Exception {
        TableHelper tEnumEntity = new TableHelper(this.dbHelper, "ENUM_ENTITY");
        tEnumEntity.setColumns(new String[]{"ID", "ENUM_ATTRIBUTE"});
        tEnumEntity.insert(new Object[]{1, "two"});
        tEnumEntity.insert(new Object[]{2, "one"});
    }

    @Test
    public void testInsert() {
        EnumEntity e = this.context.newObject(EnumEntity.class);
        e.setEnumAttribute(Enum1.one);
        this.context.commitChanges();
    }

    @Test
    public void testSelectQuery() throws Exception {
        this.createDataSet();
        SelectQuery<EnumEntity> q = new SelectQuery<EnumEntity>(EnumEntity.class);
        q.andQualifier(EnumEntity.ENUM_ATTRIBUTE.eq(Enum1.one));
        EnumEntity e = (EnumEntity)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)e);
        Assert.assertSame((Object)((Object)Enum1.one), (Object)((Object)e.getEnumAttribute()));
    }

    @Test
    public void testSQLTemplate() throws Exception {
        this.createDataSet();
        SQLTemplate q = new SQLTemplate(EnumEntity.class, "SELECT * FROM ENUM_ENTITY WHERE ENUM_ATTRIBUTE = 'one'");
        q.setColumnNamesCapitalization(CapsStrategy.UPPER);
        EnumEntity e = (EnumEntity)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)e);
        Assert.assertSame((Object)((Object)Enum1.one), (Object)((Object)e.getEnumAttribute()));
    }

    @Test
    public void createObjectWithEnumQualifier() {
        EnumEntity2 test = this.context.newObject(EnumEntity2.class);
        this.context.commitChanges();
        Assert.assertEquals((Object)((Object)Enum1.two), (Object)((Object)test.getEnumAttribute()));
    }

    @Test
    public void testEnumMappedToChar() {
        EnumEntity3 enumEntity3 = this.context.newObject(EnumEntity3.class);
        enumEntity3.setEnumAttribute(Enum1.two);
        this.context.commitChanges();
        List enumEntity3s = ObjectSelect.query(EnumEntity3.class).select(this.context);
        Assert.assertEquals((long)1L, (long)enumEntity3s.size());
        Assert.assertEquals((Object)((Object)Enum1.two), (Object)((Object)((EnumEntity3)enumEntity3s.get(0)).getEnumAttribute()));
    }
}

