/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import junit.framework.TestCase;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.embeddable.EmbedEntity1;
import org.apache.cayenne.testdo.embeddable.Embeddable1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-embeddable.xml")
public class EmbeddingSerializeIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tEmbedEntity1;

    @Before
    public void setUp() throws Exception {
        this.tEmbedEntity1 = new TableHelper(this.dbHelper, "EMBED_ENTITY1");
        this.tEmbedEntity1.setColumns(new String[]{"ID", "NAME", "EMBEDDED10", "EMBEDDED20", "EMBEDDED30", "EMBEDDED40"});
    }

    protected void createSelectDataSet() throws Exception {
        this.tEmbedEntity1.delete().execute();
        this.tEmbedEntity1.insert(new Object[]{1, "n1", "e1", "e2", "e3", "e4"});
    }

    @Test
    public void testSerializationEntityWithEmbeddableCommited() throws Exception {
        this.createSelectDataSet();
        ObjectSelect<EmbedEntity1> query = ObjectSelect.query(EmbedEntity1.class);
        List results = query.select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Assert.assertNotNull((Object)o1);
        EmbedEntity1 o2 = Util.cloneViaSerialization(o1);
        Assert.assertNotNull((Object)o2);
        Assert.assertEquals((long)o1.getPersistenceState(), (long)3L);
        Assert.assertEquals((long)o2.getPersistenceState(), (long)5L);
        Assert.assertEquals((Object)"e1", (Object)o1.getEmbedded1().getEmbedded10());
        Assert.assertEquals((Object)"e3", (Object)o1.getEmbedded2().getEmbedded10());
        TestCase.assertNull((Object)o2.getEmbedded1());
        TestCase.assertNull((Object)o2.getEmbedded2());
    }

    @Test
    public void testSerializationEntityWithEmbeddableModified() throws Exception {
        this.createSelectDataSet();
        ObjectSelect<EmbedEntity1> query = ObjectSelect.query(EmbedEntity1.class);
        List results = query.select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Assert.assertNotNull((Object)o1);
        o1.setPersistenceState(4);
        EmbedEntity1 o2 = Util.cloneViaSerialization(o1);
        Assert.assertNotNull((Object)o2);
        Assert.assertEquals((long)o1.getPersistenceState(), (long)4L);
        Assert.assertEquals((long)o2.getPersistenceState(), (long)4L);
        Assert.assertEquals((Object)"e1", (Object)o1.getEmbedded1().getEmbedded10());
        Assert.assertEquals((Object)"e1", (Object)o2.getEmbedded1().getEmbedded10());
        Assert.assertEquals((Object)"e3", (Object)o1.getEmbedded2().getEmbedded10());
        Assert.assertEquals((Object)"e3", (Object)o2.getEmbedded2().getEmbedded10());
    }

    @Test
    public void testSerializationEmbeddable() throws Exception {
        this.createSelectDataSet();
        ObjectSelect<EmbedEntity1> query = ObjectSelect.query(EmbedEntity1.class);
        List results = query.select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Assert.assertNotNull((Object)o1);
        Embeddable1 e1 = o1.getEmbedded1();
        Embeddable1 e2 = Util.cloneViaSerialization(e1);
        Assert.assertEquals((Object)e1.getEmbedded10(), (Object)e2.getEmbedded10());
    }
}

