/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPrefetchQualifierOverlapIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    private void createTwoArtistsThreePaintingsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        TableHelper tPainting = new TableHelper(this.dbHelper, "PAINTING");
        tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID"});
        tArtist.insert(new Object[]{1, "A1"});
        tArtist.insert(new Object[]{2, "A2"});
        tPainting.insert(new Object[]{1, "ABC", 1});
        tPainting.insert(new Object[]{2, "ABD", 1});
        tPainting.insert(new Object[]{3, "ACC", 1});
    }

    @Test
    public void testToManyDisjointOverlappingQualifierWithInnerJoin() throws Exception {
        this.createTwoArtistsThreePaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("paintingArray.paintingTitle", (Object)"AB%"));
        query.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        Artist a = (Artist)result.get(0);
        Assert.assertEquals((long)3L, (long)a.getPaintingArray().size());
    }

    @Test
    public void testToManyJointOverlappingQualifierWithInnerJoin() throws Exception {
        this.createTwoArtistsThreePaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("paintingArray.paintingTitle", (Object)"AB%"));
        query.addPrefetch(Artist.PAINTING_ARRAY.joint());
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        Artist a = (Artist)result.get(0);
        Assert.assertEquals((long)3L, (long)a.getPaintingArray().size());
    }

    @Test
    public void testToManyJointOverlappingQualifierWithOuterJoin() throws Exception {
        this.createTwoArtistsThreePaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("paintingArray+.paintingTitle", (Object)"AB%"));
        query.addPrefetch(Artist.PAINTING_ARRAY.joint());
        query.orQualifier(ExpressionFactory.likeExp("artistName", (Object)"A%"));
        query.addOrdering(Artist.ARTIST_NAME.asc());
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)result.size());
        Artist a = (Artist)result.get(0);
        Assert.assertEquals((long)3L, (long)a.getPaintingArray().size());
        Artist a1 = (Artist)result.get(1);
        Assert.assertEquals((long)0L, (long)a1.getPaintingArray().size());
    }
}

