/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_people.AbstractPerson;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataContextObjectIdQuery_PolymorphicIT
extends PeopleProjectCase {
    @Inject
    private DataContext context1;
    @Inject
    private DataContext context2;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    private TableHelper tPerson;

    @Before
    public void before() {
        this.tPerson = new TableHelper(this.dbHelper, "PERSON").setColumns(new String[]{"PERSON_ID", "NAME", "PERSON_TYPE"}).setColumnTypes(new int[]{4, 12, 1});
    }

    @Test
    public void testPolymorphicSharedCache() throws SQLException {
        this.tPerson.insert(new Object[]{1, "P1", "EM"});
        final ObjectIdQuery q1 = new ObjectIdQuery(new ObjectId("AbstractPerson", "PERSON_ID", 1), false, 1);
        AbstractPerson ap1 = (AbstractPerson)Cayenne.objectForQuery(this.context1, q1);
        Assert.assertTrue((boolean)(ap1 instanceof Manager));
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                AbstractPerson ap2 = (AbstractPerson)Cayenne.objectForQuery(DataContextObjectIdQuery_PolymorphicIT.this.context2, q1);
                Assert.assertTrue((boolean)(ap2 instanceof Manager));
            }
        });
    }

    @Test
    public void testPolymorphicSharedCache_AfterCayenneInsert() throws SQLException {
        Employee e = this.context1.newObject(Employee.class);
        e.setName("E1");
        e.setSalary(Float.valueOf(1234.01f));
        this.context1.commitChanges();
        final ObjectIdQuery q1 = new ObjectIdQuery(new ObjectId("AbstractPerson", "PERSON_ID", Cayenne.intPKForObject(e)), false, 1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                AbstractPerson ap1 = (AbstractPerson)Cayenne.objectForQuery(DataContextObjectIdQuery_PolymorphicIT.this.context2, q1);
                Assert.assertTrue((boolean)(ap1 instanceof Employee));
            }
        });
    }

    @Test
    public void testPolymorphicLocalCache() throws SQLException {
        this.tPerson.insert(new Object[]{1, "P1", "EM"});
        final ObjectIdQuery q1 = new ObjectIdQuery(new ObjectId("AbstractPerson", "PERSON_ID", 1), false, 1);
        AbstractPerson ap1 = (AbstractPerson)Cayenne.objectForQuery(this.context1, q1);
        Assert.assertTrue((boolean)(ap1 instanceof Manager));
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                AbstractPerson ap2 = (AbstractPerson)Cayenne.objectForQuery(DataContextObjectIdQuery_PolymorphicIT.this.context1, q1);
                Assert.assertTrue((boolean)(ap2 instanceof Manager));
            }
        });
    }
}

